/*
 * Decompiled with CFR 0.152.
 */
package xyz.bonfiremc.windy.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

public class WindParticle
extends SingleQuadParticle {
    private final SpriteSet sprites;

    public WindParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet sprites) {
        super(world, x, y, z, velocityX, velocityY, velocityZ, sprites.first());
        this.hasPhysics = true;
        this.lifetime = 50;
        this.scale(50.5f);
        this.setAlpha(0.5f);
        this.setPos(x, y, z);
        this.setSpriteFromAge(sprites);
        this.sprites = sprites;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    @NotNull
    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Factory(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(@NotNull SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, RandomSource random) {
            int distance = random.nextInt(30) + 40;
            double angle = random.nextDouble() * Math.PI * 2.0;
            double newY = y + (double)random.nextInt(15) + (double)random.nextInt(15);
            return new WindParticle(world, Math.cos(angle) * (double)distance + x, newY, Math.sin(angle) * (double)distance + z, velocityX, velocityY, velocityZ, this.sprites);
        }
    }
}

