/*
 * Decompiled with CFR 0.152.
 */
package xyz.bonfiremc.windy;

import java.nio.file.Path;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import xyz.bonfiremc.windy.WindyConfig;
import xyz.bonfiremc.windy.WindyParticles;
import xyz.bonfiremc.windy.particle.WindParticle;

@Mod(value="windy")
public class WindyMod {
    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"windy", (String)path);
    }

    public WindyMod(IEventBus modBus) {
        WindyConfig.HANDLER.load();
        WindyParticles.init();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> WindyConfig.HANDLER.generateGui().generateScreen(parent));
        WindyParticles.PARTICLE_TYPES.register(modBus);
        modBus.addListener(WindyMod::registerParticleProviders);
    }

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get().resolve("windy-config.json");
    }

    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)WindyParticles.WIND.get(), WindParticle.Factory::new);
        event.registerSpriteSet((ParticleType)WindyParticles.STRONG_WIND.get(), WindParticle.Factory::new);
    }
}

