/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.searchstats.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.terminalmc.searchstats.SearchStats;
import dev.terminalmc.searchstats.util.Localization;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StatsScreen.class})
public abstract class StatsScreenMixin
extends Screen {
    @Shadow
    private boolean isLoading;
    @Shadow
    @Nullable
    private TabNavigationBar tabNavigationBar;
    @Unique
    private EditBox searchstats$searchField;

    @Shadow
    public abstract void onStatsUpdated();

    public StatsScreenMixin(Component text) {
        super(text);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void afterInit(CallbackInfo ci) {
        SearchStats.setSearchString("");
    }

    @WrapOperation(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/layouts/HeaderAndFooterLayout;addToFooter(Lnet/minecraft/client/gui/layouts/LayoutElement;)Lnet/minecraft/client/gui/layouts/LayoutElement;")})
    private <T extends LayoutElement> T wrapAddDoneButton(HeaderAndFooterLayout instance, T child, Operation<T> original) {
        int height = 18;
        int fieldWidth = 120;
        this.searchstats$searchField = new EditBox(this.font, fieldWidth, height, (Component)Component.empty());
        this.searchstats$searchField.setCanLoseFocus(false);
        this.searchstats$searchField.setFocused(true);
        this.searchstats$searchField.setHint((Component)Localization.localized("hint", new Object[0]));
        LinearLayout layout = new LinearLayout(this.width, Math.max(height, child.getHeight()), LinearLayout.Orientation.HORIZONTAL);
        layout.addChild((LayoutElement)this.searchstats$searchField);
        if (child instanceof LinearLayout) {
            LinearLayout l = (LinearLayout)child;
            l.visitChildren(arg_0 -> ((LinearLayout)layout).addChild(arg_0));
        } else {
            if (child instanceof Button) {
                Button b = (Button)child;
                b.setWidth(Math.max(120, b.getWidth() / 2));
            }
            layout.addChild(child);
        }
        original.call(new Object[]{instance, layout});
        return null;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.searchstats$searchField != null && this.searchstats$searchField.keyPressed(event)) {
            this.searchstats$refresh();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean charTyped(CharacterEvent event) {
        if (this.searchstats$searchField.charTyped(event)) {
            this.searchstats$refresh();
            return true;
        }
        return super.charTyped(event);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.searchstats$searchField != null && this.searchstats$searchField.mouseClicked(event, doubleClick)) {
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    @Unique
    private void searchstats$refresh() {
        SearchStats.setSearchString(this.searchstats$searchField.getValue());
        int selected = SearchStats.selectedTab;
        this.isLoading = true;
        this.onStatsUpdated();
        if (selected >= 0 && this.tabNavigationBar != null) {
            this.tabNavigationBar.selectTab(selected, false);
        }
    }
}

