/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPILogger;
import dev.jorel.commandapi.CommandAPIVelocityConfig;
import dev.jorel.commandapi.config.DefaultVelocityConfig;
import dev.jorel.commandapi.config.VelocityConfigurationAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@Plugin(id="commandapi", name="CommandAPI", version="${project.version}", url="https://commandapi.jorel.dev", description="An API to use Minecraft 1.13s new command UI", authors={"Skepter"})
public class CommandAPIMain {
    @Inject
    public CommandAPIMain(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        ConfigurationNode configYAML;
        Path configFile = dataDirectory.resolve("config.yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().nodeStyle(NodeStyle.BLOCK).path(configFile)).build();
        VelocityConfigurationAdapter.createMinimalInstance(loader).saveDefaultConfig(DefaultVelocityConfig.createDefault(), configFile.getParent().toFile(), logger);
        try {
            configYAML = loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommandAPIVelocityConfig config = (CommandAPIVelocityConfig)((CommandAPIVelocityConfig)((CommandAPIVelocityConfig)((CommandAPIVelocityConfig)((CommandAPIVelocityConfig)((CommandAPIVelocityConfig)new CommandAPIVelocityConfig(server, this).verboseOutput(configYAML.node(new Object[]{"verbose-outputs"}).getBoolean())).silentLogs(configYAML.node(new Object[]{"silent-logs"}).getBoolean())).missingExecutorImplementationMessage(configYAML.node(new Object[]{"messages", "missing-executor-implementation"}).getString())).dispatcherFile(configYAML.node(new Object[]{"create-dispatcher-json"}).getBoolean() ? new File(dataDirectory.toFile(), "command_registration.json") : null)).enableNetworking(configYAML.node(new Object[]{"enable-networking"}).getBoolean())).makeNetworkingExceptionsWarnings(configYAML.node(new Object[]{"make-networking-exceptions-warnings"}).getBoolean());
        CommandAPI.setLogger(CommandAPILogger.fromJavaLogger(logger));
        CommandAPI.onLoad(config);
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        CommandAPI.onEnable();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        CommandAPI.onDisable();
    }

    @Subscribe
    public void onProxyReload(ProxyReloadEvent event) {
    }
}

