/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPIHandler;
import java.util.Optional;

public class CommandAPIVelocityConfig
extends CommandAPIConfig<CommandAPIVelocityConfig> {
    ProxyServer server;
    Object plugin;

    public CommandAPIVelocityConfig(ProxyServer server, Object plugin) {
        this.server = server;
        this.plugin = plugin;
        super.setNamespace("");
    }

    public CommandAPIVelocityConfig usePluginNamespace() {
        Optional pluginContainerOptional = this.server.getPluginManager().fromInstance(this.plugin);
        if (pluginContainerOptional.isEmpty()) {
            CommandAPI.logInfo("Cannot use plugin namespace because " + this.plugin.getClass().getSimpleName() + " is not a Velocity plugin! The currently set namespace wasn't changed.");
            return this.instance();
        }
        super.setNamespace(((PluginContainer)pluginContainerOptional.get()).getDescription().getId());
        this.usePluginNamespace = true;
        return this.instance();
    }

    @Override
    public CommandAPIVelocityConfig setNamespace(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Default namespace can't be null!");
        }
        if (!CommandAPIHandler.NAMESPACE_PATTERN.matcher(namespace).matches()) {
            CommandAPI.logNormal("Did not set namespace to the provided '" + namespace + "' namespace because only 0-9, a-z, underscores, periods and hyphens are allowed!");
            return this;
        }
        return (CommandAPIVelocityConfig)super.setNamespace(namespace);
    }

    @Override
    public CommandAPIVelocityConfig instance() {
        return this;
    }
}

