/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.AdvancedConverter;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPILogger;
import dev.jorel.commandapi.CommandAPISpigotConfig;
import dev.jorel.commandapi.Converter;
import dev.jorel.commandapi.config.BukkitConfigurationAdapter;
import dev.jorel.commandapi.config.DefaultBukkitConfig;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandAPIMain
extends JavaPlugin {
    private static final String PLUGINS_TO_CONVERT = "plugins-to-convert";

    public void onLoad() {
        this.saveDefaultConfig();
        FileConfiguration fileConfig = this.getConfig();
        CommandAPISpigotConfig config = ((CommandAPISpigotConfig)((CommandAPISpigotConfig)((CommandAPISpigotConfig)((CommandAPISpigotConfig)((CommandAPISpigotConfig)new CommandAPISpigotConfig(this).verboseOutput(fileConfig.getBoolean("verbose-outputs"))).silentLogs(fileConfig.getBoolean("silent-logs"))).fallbackToLatestNMS(fileConfig.getBoolean("fallback-to-latest-nms"))).missingExecutorImplementationMessage(fileConfig.getString("messages.missing-executor-implementation"))).dispatcherFile(fileConfig.getBoolean("create-dispatcher-json") ? new File(this.getDataFolder(), "command_registration.json") : null)).skipReloadDatapacks(fileConfig.getBoolean("skip-initial-datapack-reload"));
        for (String pluginName : fileConfig.getStringList("skip-sender-proxy")) {
            if (Bukkit.getPluginManager().getPlugin(pluginName) != null) {
                config.addSkipSenderProxy(pluginName);
                continue;
            }
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        CommandAPI.setLogger(CommandAPILogger.fromJavaLogger(this.getLogger()));
        CommandAPI.onLoad(config);
        if (!fileConfig.getList(PLUGINS_TO_CONVERT).isEmpty() && fileConfig.getMapList(PLUGINS_TO_CONVERT).isEmpty()) {
            CommandAPI.logError("plugins-to-convert has an invalid type. Did you miss a colon (:) after a plugin name?");
        }
        this.convertCommands(fileConfig);
    }

    private void convertCommands(FileConfiguration fileConfig) {
        HashMap<JavaPlugin, String[]> pluginsToConvert = new HashMap<JavaPlugin, String[]>();
        for (Map map : fileConfig.getMapList(PLUGINS_TO_CONVERT)) {
            JavaPlugin plugin;
            String[] pluginCommands;
            if (map.values().size() == 1 && map.values().iterator().next() == null) {
                pluginCommands = new String[]{};
            } else {
                List commands = (List)map.values().iterator().next();
                pluginCommands = commands.toArray(new String[0]);
            }
            if ((plugin = this.getAndValidatePlugin((String)map.keySet().iterator().next())) == null) continue;
            pluginsToConvert.put(plugin, pluginCommands);
        }
        for (Map.Entry entry : pluginsToConvert.entrySet()) {
            if (((String[])entry.getValue()).length == 0) {
                Converter.convert((JavaPlugin)entry.getKey());
                continue;
            }
            for (String command : (String[])entry.getValue()) {
                new AdvancedConverter((JavaPlugin)entry.getKey(), command).convert();
            }
        }
        for (String string : fileConfig.getStringList("other-commands-to-convert")) {
            new AdvancedConverter(string).convertCommand();
        }
    }

    private JavaPlugin getAndValidatePlugin(String pluginName) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin != null) {
            if (plugin instanceof JavaPlugin) {
                JavaPlugin javaPlugin = (JavaPlugin)plugin;
                return javaPlugin;
            }
            new InvalidPluginException("Plugin " + pluginName + " is not a JavaPlugin!").printStackTrace();
        } else {
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        return null;
    }

    public void onEnable() {
        CommandAPI.onEnable();
    }

    public void saveDefaultConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        BukkitConfigurationAdapter.createMinimalInstance(configFile).saveDefaultConfig(DefaultBukkitConfig.createDefaultSpigotConfig(), this.getDataFolder(), this.getLogger());
    }
}

