/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.arguments.parser.EntitySelectorParser;
import dev.jorel.commandapi.arguments.parser.RegistryParser;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.nms.NativeProxyCommandSender_1_20_R2;
import dev.jorel.commandapi.wrappers.DoubleRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_20_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftSound;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_20_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionEffectType;
import org.bukkit.entity.Entity;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class NMS_1_20_R2
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final SafeVarHandle<ArgumentPredicateItemStack, NBTTagCompound> itemInput;
    private static final Field serverFunctionLibraryDispatcher;
    private static final SafeVarHandle<ArgumentTileLocation, NBTTagCompound> blockInputTag;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    @Override
    protected CommandBuildContext getCommandBuildContext() {
        return COMMAND_BUILD_CONTEXT;
    }

    @Override
    public ArgumentType<?> _ArgumentAdvancement() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.r);
    }

    @Override
    public ArgumentType<?> _ArgumentRecipe() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ap);
    }

    @Override
    public final Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.20.2"};
    }

    @Override
    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).w().r_();
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        return CraftParticle.createParticleParam((org.bukkit.Particle)particle.particle(), particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).aA().a(commandFunction, css);
        CustomFunction.d[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(this.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).toBukkit();
    }

    @Override
    public final RegistryParser<Biome> getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        MinecraftKey resourceLocation = ResourceArgument.a(cmdCtx, (String)key, (ResourceKey)Registries.ap).g().a();
        return new RegistryParser<Biome>(() -> {
            Biome biome;
            try {
                biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
            }
            catch (IllegalArgumentException biomeNotFound) {
                biome = null;
            }
            return biome;
        }, () -> this.fromResourceLocation(resourceLocation));
    }

    @Override
    public final BlockState getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ArgumentTileLocation input = ArgumentTile.a(cmdCtx, (String)key);
        BlockState snapshot = CraftBlockStates.getBlockState((BlockPosition)BlockPosition.b, (IBlockData)input.a(), null);
        if (blockInputTag.get(input) != null && snapshot instanceof CraftBlockEntityState) {
            CraftBlockEntityState blockEntitySnapshot = (CraftBlockEntityState)snapshot;
            blockEntitySnapshot.loadData(blockInputTag.get(input));
        }
        return snapshot;
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender.getSource());
    }

    @Override
    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return org.bukkit.enchantments.Enchantment.getByKey((NamespacedKey)this.fromResourceLocation(BuiltInRegistries.g.b((Object)((Enchantment)ResourceArgument.g(cmdCtx, (String)key).a()))));
    }

    @Override
    public final EntitySelectorParser getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new EntitySelectorParser(() -> argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity(), () -> argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity(), allowEmpty -> {
            try {
                ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                    result.add(player.getBukkitEntity());
                }
                if (result.isEmpty() && !allowEmpty.booleanValue()) {
                    throw ArgumentEntity.e.create();
                }
                return result;
            }
            catch (CommandSyntaxException e) {
                if (allowEmpty.booleanValue()) {
                    return new ArrayList();
                }
                throw e;
            }
        }, allowEmpty -> {
            try {
                ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                for (net.minecraft.world.entity.Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                    result.add(entity.getBukkitEntity());
                }
                if (result.isEmpty() && !allowEmpty.booleanValue()) {
                    throw ArgumentEntity.d.create();
                }
                return result;
            }
            catch (CommandSyntaxException e) {
                if (allowEmpty.booleanValue()) {
                    return new ArrayList();
                }
                throw e;
            }
        });
    }

    @Override
    public DoubleRange getDoubleRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.DoubleRange range = ArgumentCriterionValue.a.a(cmdCtx, (String)key);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -1.7976931348623157E308 : lowBoxed;
        double high = highBoxed == null ? Double.MAX_VALUE : highBoxed;
        return new DoubleRange(low, high);
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        MinecraftKey resourceLocation = new MinecraftKey(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aA().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CustomFunction)commandFunctionOptional.get());
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aA().e()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public final ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        net.minecraft.world.item.ItemStack itemWithMaybeTag = input.a(1, false);
        NBTTagCompound tag = itemInput.get(input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.world.item.ItemStack)itemWithMaybeTag));
        return result;
    }

    @Override
    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return new CraftLootTable(this.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aH().getLootTable(resourceLocation));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return this.fromResourceLocation(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key));
    }

    @Override
    public final Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        org.bukkit.Particle particle = CraftParticle.minecraftToBukkit((Particle)particleOptions.b());
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options.c()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.c()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.c());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(org.bukkit.Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, org.bukkit.Particle particle, VibrationParticleOption options) {
        Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).d();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        PositionSource positionSource = options.c();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.c()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3D to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.d()));
    }

    @Override
    public RegistryParser<PotionEffectType> getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new RegistryParser<PotionEffectType>(() -> CraftPotionEffectType.minecraftToBukkit((MobEffectList)((MobEffectList)ResourceArgument.f((CommandContext)cmdCtx, (String)key).a())), () -> this.fromResourceLocation(ArgumentMinecraftKeyRegistered.e((CommandContext)cmdCtx, (String)key)));
    }

    @Override
    public final <T extends Recipe> T getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key, BiFunction<NamespacedKey, Recipe, T> result) throws CommandSyntaxException {
        RecipeHolder recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key);
        return (T)((Recipe)result.apply(this.fromResourceLocation(recipe.a()), recipe.toBukkitRecipe()));
    }

    @Override
    public final Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Vec2F rotation = ArgumentRotation.a(cmdCtx, (String)key).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(rotation.j, rotation.i);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key).a());
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.b(cmdCtx, (String)key);
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key);
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        net.minecraft.world.entity.Entity proxyEntity;
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        CraftEntity craftEntity = proxy = (proxyEntity = css.f()) == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender_1_20_R2(css, sender, (CommandSender)proxy));
        }
        return CommandAPIBukkit.get().wrapCommandSender(sender);
    }

    @Override
    public NativeProxyCommandSender createNativeProxyCommandSender(CommandSender caller, CommandSender callee, Location location, World world) {
        if (callee == null) {
            callee = caller;
        }
        CommandListenerWrapper css = this.getBrigadierSourceFromCommandSender(CommandAPIBukkit.get().wrapCommandSender(caller));
        if (location != null) {
            css = css.a(new Vec3D(location.getX(), location.getY(), location.getZ())).a(new Vec2F(location.getPitch(), location.getYaw()));
        }
        if (world == null && location != null) {
            world = location.getWorld();
        }
        if (world != null) {
            css = css.a(((CraftWorld)world).getHandle());
        }
        if (callee instanceof Entity) {
            Entity e = (Entity)callee;
            css = css.a(((CraftEntity)e).getHandle());
        }
        return new NativeProxyCommandSender_1_20_R2(css, caller, callee);
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final RegistryParser<Sound> getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return new RegistryParser<Sound>(() -> {
            SoundEffect soundEvent = (SoundEffect)BuiltInRegistries.c.a(soundResource);
            if (soundEvent == null) {
                return null;
            }
            return CraftSound.minecraftToBukkit((SoundEffect)soundEvent);
        }, () -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a())));
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).aA();
                ICompletionProvider.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).az().b().stream().map(AdvancementHolder::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aH().a(LootDataType.c), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.d;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> ICompletionProvider.a((Iterable)BuiltInRegistries.e.e(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).aA().b(new MinecraftKey(key.getNamespace(), key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CustomFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction(customFunction);
        }
        return convertedCustomFunctions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aA().f()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public final Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).at;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aC();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), CommandAPIBukkit.get().getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aB().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aT().F().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aB().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        IRegistryCustom.Dimension registryAccess = ((MinecraftServer)this.getMinecraftServer()).aU();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aB();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).ar, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).at.close();
            ((MinecraftServer)this.getMinecraftServer()).at = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aB().a(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aB().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aB().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aT().a(new WorldDataConfiguration(new DataPackConfiguration((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).aT().F().b()));
            ((MinecraftServer)this.getMinecraftServer()).at.b().a((IRegistryCustom)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).aS().a((IResourceManager)((MinecraftServer)this.getMinecraftServer()).at.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bl()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            CommandAPIBukkit.get().registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.O);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.s);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.a((IRegistryCustom)server2.getServer().aU(), (FeatureFlagSet)server2.getServer().aT().F().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "p", "usesSelector");
        itemInput = SafeVarHandle.ofOrNull(ArgumentPredicateItemStack.class, "c", "tag", NBTTagCompound.class);
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, "g", "dispatcher");
        blockInputTag = SafeVarHandle.ofOrNull(ArgumentTileLocation.class, "c", "tag", NBTTagCompound.class);
    }
}

