/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.network.packets;

import dev.jorel.commandapi.network.CommandAPIPacket;
import dev.jorel.commandapi.network.FriendlyByteBuffer;

public record ProtocolVersionTooOldPacket(int protocolVersion, String reason) implements CommandAPIPacket
{
    public static final int MAX_REASON_LENGTH = 256;

    public static ProtocolVersionTooOldPacket deserialize(FriendlyByteBuffer buffer) {
        int protocolVersion = buffer.readVarInt();
        String reason = buffer.readString(256);
        return new ProtocolVersionTooOldPacket(protocolVersion, reason);
    }

    @Override
    public void write(FriendlyByteBuffer buffer, Object target, int protocolVersion) {
        buffer.writeVarInt(this.protocolVersion);
        buffer.writeString(this.reason, 256);
    }
}

