/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffectType;

public abstract class NMS_Common
implements NMS<CommandListenerWrapper> {
    protected abstract CommandBuildContext getCommandBuildContext();

    @Override
    public final ArgumentType<?> _ArgumentAngle() {
        return ArgumentAngle.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentAxis() {
        return ArgumentRotationAxis.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentChat() {
        return ArgumentChat.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentChatFormat.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentDimension() {
        return ArgumentDimension.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentFloatRange() {
        return ArgumentCriterionValue.b();
    }

    @Override
    public final ArgumentType<?> _ArgumentIntRange() {
        return ArgumentCriterionValue.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentMathOperation() {
        return ArgumentMathOperation.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentNBTCompound() {
        return ArgumentNBTTag.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentPosition() {
        return ArgumentPosition.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentPosition2D() {
        return ArgumentVec2I.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentProfile() {
        return ArgumentProfile.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentRotation() {
        return ArgumentRotation.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentScoreboardCriteria.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardObjective() {
        return ArgumentScoreboardObjective.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentScoreboardSlot.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardTeam() {
        return ArgumentScoreboardTeam.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ArgumentScoreholder.a();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ArgumentScoreholder.b();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentTag() {
        return ArgumentTag.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentTime() {
        return ArgumentTime.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentUUID() {
        return ArgumentUUID.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return ArgumentVec2.a((boolean)centerPosition);
    }

    @Override
    public final ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return ArgumentVec3.a((boolean)centerPosition);
    }

    @Override
    public final String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public final String convert(Sound sound) {
        return sound.getKey().toString();
    }

    @Override
    public final void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    @Override
    public final float getAngle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentAngle.a(cmdCtx, (String)key);
    }

    @Override
    public final EnumSet<Axis> getAxis(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = ArgumentRotationAxis.a(cmdCtx, (String)key);
        for (EnumDirection.EnumAxis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case EnumDirection.EnumAxis.a -> Axis.X;
                case EnumDirection.EnumAxis.b -> Axis.Y;
                case EnumDirection.EnumAxis.c -> Axis.Z;
            });
        }
        return set;
    }

    @Override
    public final Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).e(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public final BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandListenerWrapper css) {
        try {
            return CommandAPIBukkit.get().wrapCommandSender(css.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public final EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.a((EntityTypes)((EntityTypes)ResourceArgument.e(cmdCtx, (String)key).a())).a());
    }

    @Override
    public final Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.c(), blockPos.d());
    }

    @Override
    public final Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.c(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    @Override
    public final Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)key).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    @Override
    public final MathOperation getMathOperation(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentMathOperation.a(cmdCtx, (String)key);
        return MathOperation.fromString(CommandAPIHandler.getRawArgumentInput(cmdCtx, key));
    }

    @Override
    public final <NBTContainer> Object getNBTCompound(CommandContext<CommandListenerWrapper> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(ArgumentNBTTag.a(cmdCtx, (String)key));
    }

    @Override
    public final String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key).d();
    }

    @Override
    public final int getTime(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    @Override
    public final UUID getUUID(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentUUID.a(cmdCtx, (String)key);
    }
}

