/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelMessageSink;
import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandAPILogger;
import dev.jorel.commandapi.CommandAPIPlatform;
import dev.jorel.commandapi.CommandMetaData;
import dev.jorel.commandapi.InternalVelocityConfig;
import dev.jorel.commandapi.RegisteredCommand;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.AbstractPlayer;
import dev.jorel.commandapi.commandsenders.VelocityCommandSender;
import dev.jorel.commandapi.commandsenders.VelocityConsoleCommandSender;
import dev.jorel.commandapi.commandsenders.VelocityPlayer;
import dev.jorel.commandapi.network.VelocityCommandAPIMessenger;
import dev.jorel.commandapi.network.packets.UpdateRequirementsPacket;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;

public class CommandAPIVelocity
implements CommandAPIPlatform<Argument<?>, CommandSource, CommandSource> {
    private static CommandAPIVelocity instance;
    private static InternalVelocityConfig config;
    private VelocityCommandAPIMessenger messenger;
    private CommandManager commandManager;
    private CommandDispatcher<CommandSource> dispatcher;

    public CommandAPIVelocity(InternalVelocityConfig config) {
        CommandAPIVelocity.config = config;
        instance = this;
    }

    public static CommandAPIVelocity get() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("Tried to access CommandAPIVelocity instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public static InternalVelocityConfig getConfiguration() {
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("Tried to access InternalVelocityConfig, but it was null! Did you load the CommandAPI properly with CommandAPI#onLoad?");
    }

    @Override
    public void onLoad() {
        this.commandManager = CommandAPIVelocity.getConfiguration().getServer().getCommandManager();
        Field dispatcherField = CommandAPIHandler.getField(this.commandManager.getClass(), "dispatcher");
        try {
            this.dispatcher = (CommandDispatcher)dispatcherField.get(this.commandManager);
        }
        catch (Exception ignored) {
            CommandAPI.logError("Could not access Velocity's Brigadier CommandDispatcher");
        }
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void registerPermission(String string) {
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces) {
        this.commandManager.unregister(commandName);
    }

    public VelocityCommandAPIMessenger setupMessenger() {
        this.messenger = new VelocityCommandAPIMessenger(CommandAPIVelocity.getConfiguration().getPlugin(), CommandAPIVelocity.getConfiguration().getServer());
        return this.messenger;
    }

    public VelocityCommandAPIMessenger getMessenger() {
        return this.messenger;
    }

    @Override
    public CommandDispatcher<CommandSource> getBrigadierDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<CommandSource> brigadierDispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)CommandAPIVelocity.serializeNodeToJson(this.dispatcher, (CommandNode<CommandSource>)this.dispatcher.getRoot())));
    }

    private static JsonObject serializeNodeToJson(CommandDispatcher<CommandSource> dispatcher, CommandNode<CommandSource> node) {
        Collection redirectPath;
        JsonObject output = new JsonObject();
        if (node instanceof RootCommandNode) {
            output.addProperty("type", "root");
        } else if (node instanceof LiteralCommandNode) {
            output.addProperty("type", "literal");
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentType type = ((ArgumentCommandNode)node).getType();
            output.addProperty("type", "argument");
            output.addProperty("argumentType", type.getClass().getName());
        } else {
            CommandAPI.logError("Could not serialize node %s (%s)!".formatted(node, node.getClass()));
            output.addProperty("type", "unknown");
        }
        JsonObject children = new JsonObject();
        for (CommandNode child : node.getChildren()) {
            children.add(child.getName(), (JsonElement)CommandAPIVelocity.serializeNodeToJson(dispatcher, (CommandNode<CommandSource>)child));
        }
        if (children.size() > 0) {
            output.add("children", (JsonElement)children);
        }
        if (node.getCommand() != null) {
            output.addProperty("executable", Boolean.valueOf(true));
        }
        if (node.getRedirect() != null && !(redirectPath = dispatcher.getPath(node.getRedirect())).isEmpty()) {
            JsonArray redirectInfo = new JsonArray();
            redirectPath.forEach(arg_0 -> ((JsonArray)redirectInfo).add(arg_0));
            output.add("redirect", (JsonElement)redirectInfo);
        }
        return output;
    }

    @Override
    public CommandAPILogger getLogger() {
        return CommandAPILogger.fromApacheLog4jLogger(LogManager.getLogger((String)"CommandAPI"));
    }

    @Override
    public VelocityCommandSender<? extends CommandSource> getSenderForCommand(CommandContext<CommandSource> cmdCtx, boolean forceNative) {
        return this.getCommandSenderFromCommandSource((CommandSource)cmdCtx.getSource());
    }

    @Override
    public VelocityCommandSender<? extends CommandSource> getCommandSenderFromCommandSource(CommandSource cs) {
        if (cs instanceof ConsoleCommandSource) {
            ConsoleCommandSource ccs = (ConsoleCommandSource)cs;
            return new VelocityConsoleCommandSender(ccs);
        }
        if (cs instanceof Player) {
            Player p = (Player)cs;
            return new VelocityPlayer(p);
        }
        throw new IllegalArgumentException("Unknown CommandSource: " + String.valueOf(cs));
    }

    @Override
    public VelocityCommandSender<? extends CommandSource> wrapCommandSender(CommandSource commandSource) {
        return this.getCommandSenderFromCommandSource(commandSource);
    }

    @Override
    public CommandSource getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSource> sender) {
        return sender.getSource();
    }

    @Override
    public SuggestionProvider<CommandSource> getSuggestionProvider(SuggestionProviders suggestionProvider) {
        return (context, builder) -> Suggestions.empty();
    }

    @Override
    public void preCommandRegistration(String commandName) {
    }

    @Override
    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<CommandSource> resultantNode, List<LiteralCommandNode<CommandSource>> aliasNodes) {
    }

    @Override
    public LiteralCommandNode<CommandSource> registerCommandNode(LiteralArgumentBuilder<CommandSource> node, String namespace) {
        LiteralCommandNode builtNode = this.getBrigadierDispatcher().register(node);
        if (!namespace.isEmpty()) {
            this.getBrigadierDispatcher().getRoot().addChild(CommandAPIHandler.getInstance().namespaceNode(builtNode, namespace));
        }
        return builtNode;
    }

    @Override
    public void reloadDataPacks() {
    }

    @Override
    public void updateRequirements(AbstractPlayer<?> playerWrapper) {
        Player player = (Player)playerWrapper.getSource();
        Optional optionalServer = player.getCurrentServer();
        if (optionalServer.isEmpty()) {
            return;
        }
        this.getMessenger().sendPacket((ChannelMessageSink)optionalServer.get(), new UpdateRequirementsPacket());
    }

    @Override
    public Argument<String> newConcreteMultiLiteralArgument(String nodeName, String[] literals) {
        return new MultiLiteralArgument(nodeName, literals);
    }

    @Override
    public Argument<String> newConcreteLiteralArgument(String nodeName, String literal) {
        return new LiteralArgument(nodeName, literal);
    }

    @Override
    public AbstractCommandAPICommand<?, Argument<?>, CommandSource> newConcreteCommandAPICommand(CommandMetaData<CommandSource> meta) {
        return new CommandAPICommand(meta);
    }
}

