/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.jorel.commandapi.AbstractCommandTree;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandAPIVelocity;
import dev.jorel.commandapi.VelocityExecutable;
import dev.jorel.commandapi.arguments.Argument;
import java.util.Optional;

public class CommandTree
extends AbstractCommandTree<CommandTree, Argument<?>, CommandSource>
implements VelocityExecutable<CommandTree> {
    public CommandTree(String commandName) {
        super(commandName);
    }

    @Override
    public void register(String namespace) {
        if (!namespace.isEmpty() && !CommandAPIHandler.NAMESPACE_PATTERN.matcher(namespace).matches()) {
            super.register();
            return;
        }
        super.register(namespace);
    }

    public void register(Object plugin) {
        if (plugin == null) {
            throw new NullPointerException("Parameter 'plugin' was null while trying to register command /" + this.meta.commandName + "!");
        }
        ProxyServer server = CommandAPIVelocity.getConfiguration().getServer();
        Optional pluginContainerOptional = server.getPluginManager().fromInstance(plugin);
        if (pluginContainerOptional.isEmpty()) {
            CommandAPI.logInfo("Using the default namespace to register commands since " + plugin.getClass().getSimpleName() + " is not a Velocity plugin!");
            super.register();
            return;
        }
        super.register(((PluginContainer)pluginContainerOptional.get()).getDescription().getId());
    }

    @Override
    public CommandTree instance() {
        return this;
    }
}

