/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.config;

import dev.jorel.commandapi.config.CommentedConfigOption;
import dev.jorel.commandapi.config.CommentedSection;
import dev.jorel.commandapi.config.ConfigurationAdapter;
import dev.jorel.commandapi.config.DefaultVelocityConfig;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.Set;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class VelocityConfigurationAdapter
extends Record
implements ConfigurationAdapter<ConfigurationNode> {
    private final YamlConfigurationLoader loader;
    private final CommentedConfigurationNode config;
    private final DefaultVelocityConfig defaultVelocityConfig;

    public VelocityConfigurationAdapter(YamlConfigurationLoader loader, CommentedConfigurationNode config, DefaultVelocityConfig defaultVelocityConfig) {
        this.loader = loader;
        this.config = config;
        this.defaultVelocityConfig = defaultVelocityConfig;
    }

    public static VelocityConfigurationAdapter createMinimalInstance(YamlConfigurationLoader loader) {
        return new VelocityConfigurationAdapter(loader, null, null);
    }

    @Override
    public void setValue(String key, Object value) {
        try {
            this.node(key).set(value);
        }
        catch (SerializationException e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void setComment(String key, String[] comment) {
        this.node(key).comment(String.join((CharSequence)"\n", comment));
    }

    @Override
    public Object getValue(String key) {
        try {
            return this.node(key).get(Object.class);
        }
        catch (SerializationException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public String[] getComment(String key) {
        CommentedConfigOption<?> option = this.defaultVelocityConfig.getAllOptions().get(key);
        CommentedSection section = this.defaultVelocityConfig.getAllSections().get(key);
        return option != null ? option.comment() : section.comment();
    }

    @Override
    public Set<String> getKeys() {
        return this.nestedOptions((ConfigurationNode)this.config);
    }

    @Override
    public boolean contains(String key) {
        return !this.node(key).virtual();
    }

    @Override
    public void tryCreateSection(String key) {
    }

    @Override
    public CommentedConfigurationNode config() {
        return this.config;
    }

    @Override
    public ConfigurationAdapter<ConfigurationNode> complete() {
        return this;
    }

    @Override
    public ConfigurationAdapter<ConfigurationNode> createNew() {
        return new VelocityConfigurationAdapter(this.loader, (CommentedConfigurationNode)this.loader.createNode(), DefaultVelocityConfig.createDefault());
    }

    @Override
    public ConfigurationAdapter<ConfigurationNode> loadFromFile() throws IOException {
        return new VelocityConfigurationAdapter(this.loader, (CommentedConfigurationNode)this.loader.load(), DefaultVelocityConfig.createDefault());
    }

    @Override
    public void saveToFile() throws IOException {
        this.loader.save((ConfigurationNode)this.config);
    }

    private CommentedConfigurationNode node(String path) {
        return (CommentedConfigurationNode)this.config.node((Object[])path.split("\\."));
    }

    private Set<String> nestedOptions(ConfigurationNode node) {
        HashSet<String> keys = new HashSet<String>();
        for (Object key : node.childrenMap().keySet()) {
            ConfigurationNode nestedNode = (ConfigurationNode)node.childrenMap().get(key);
            if (nestedNode.childrenMap().isEmpty()) {
                keys.add((String)key);
                continue;
            }
            for (String nestedKey : this.nestedOptions(nestedNode)) {
                keys.add(String.valueOf(key) + "." + nestedKey);
            }
        }
        return keys;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{VelocityConfigurationAdapter.class, "loader;config;defaultVelocityConfig", "loader", "config", "defaultVelocityConfig"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{VelocityConfigurationAdapter.class, "loader;config;defaultVelocityConfig", "loader", "config", "defaultVelocityConfig"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{VelocityConfigurationAdapter.class, "loader;config;defaultVelocityConfig", "loader", "config", "defaultVelocityConfig"}, this, o);
    }

    public YamlConfigurationLoader loader() {
        return this.loader;
    }

    public DefaultVelocityConfig defaultVelocityConfig() {
        return this.defaultVelocityConfig;
    }
}

