/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandAPIPaper;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.RegisteredCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.LifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.PrioritizedLifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PaperCommandRegistration<Source>
extends CommandRegistrationStrategy<Source> {
    private final Supplier<CommandDispatcher<Source>> getBrigadierDispatcher;
    private final Predicate<CommandNode<Source>> isBukkitCommand;
    private final boolean[] lifecycleEventRegistered = new boolean[2];
    private final CommandDispatcher<CommandSourceStack> bootstrapDispatcher = new CommandDispatcher();
    private final CommandDispatcher<CommandSourceStack> pluginDispatcher = new CommandDispatcher();
    private final Set<String> commandsToRemove = new HashSet<String>();
    private final List<UnregisterInformation> unregisterInformationList = new ArrayList<UnregisterInformation>();
    private boolean scheduleReloadTask = true;

    public PaperCommandRegistration(Supplier<CommandDispatcher<Source>> getBrigadierDispatcher, Predicate<CommandNode<Source>> isBukkitCommand) {
        this.getBrigadierDispatcher = getBrigadierDispatcher;
        this.isBukkitCommand = isBukkitCommand;
    }

    public boolean isBukkitCommand(CommandNode<Source> node) {
        return this.isBukkitCommand.test(node);
    }

    @Override
    public CommandDispatcher<Source> getBrigadierDispatcher() {
        return this.getBrigadierDispatcher.get();
    }

    @Override
    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node, String namespace) {
        LiteralCommandNode built = node.build();
        this.addCommandToDispatcher((LiteralCommandNode<CommandSourceStack>)built);
        if (!namespace.equals(CommandAPIPaper.getConfiguration().getPluginName().toLowerCase())) {
            String defaultNamespace = CommandAPIPaper.getConfiguration().getPluginName().toLowerCase();
            LiteralCommandNode builtNamespace = CommandAPIHandler.getInstance().namespaceNode(built, namespace);
            this.addCommandToDispatcher(builtNamespace);
            String pluginNamespacedWithoutNamespace = defaultNamespace + ":" + built.getName();
            String pluginNamespacedWithNamespace = defaultNamespace + ":" + builtNamespace.getName();
            this.commandsToRemove.add(pluginNamespacedWithoutNamespace);
            this.commandsToRemove.add(pluginNamespacedWithNamespace);
        }
        this.scheduleReloadTask();
        return built;
    }

    private void addCommandToDispatcher(LiteralCommandNode<CommandSourceStack> node) {
        if (Bukkit.getServer() == null) {
            this.bootstrapDispatcher.getRoot().addChild(node);
        } else {
            this.pluginDispatcher.getRoot().addChild(node);
        }
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        this.removeBrigadierCommands(this.bootstrapDispatcher.getRoot(), commandName, unregisterNamespaces, c -> !unregisterBukkit ^ this.isBukkitCommand.test((CommandNode<Source>)c));
        this.removeBrigadierCommands(this.pluginDispatcher.getRoot(), commandName, unregisterNamespaces, c -> !unregisterBukkit ^ this.isBukkitCommand.test((CommandNode<Source>)c));
        this.unregisterInformationList.add(new UnregisterInformation(commandName, unregisterNamespaces, unregisterBukkit));
        this.scheduleReloadTask();
    }

    @Override
    public void preReloadDataPacks() {
        CommandAPIBukkit.get().updateHelpForCommands(CommandAPI.getRegisteredCommands());
    }

    void registerLifecycleEvent() {
        boolean bootstrap;
        boolean bl = bootstrap = Bukkit.getServer() == null;
        if (bootstrap && !this.lifecycleEventRegistered[0]) {
            BootstrapContext context = (BootstrapContext)CommandAPIPaper.getPaper().getLifecycleEventOwner();
            this.lifecycleEventRegistered[0] = true;
            this.registerLifecycleEvent(context.getLifecycleManager(), this.bootstrapDispatcher);
            return;
        }
        if (!bootstrap && !this.lifecycleEventRegistered[1]) {
            JavaPlugin plugin = (JavaPlugin)CommandAPIPaper.getPaper().getLifecycleEventOwner();
            this.lifecycleEventRegistered[1] = true;
            this.registerLifecycleEvent(plugin.getLifecycleManager(), this.pluginDispatcher);
            plugin.getLifecycleManager().registerEventHandler((LifecycleEventHandlerConfiguration)((PrioritizedLifecycleEventHandlerConfiguration)LifecycleEvents.COMMANDS.newHandler(event -> {
                if (!this.unregisterInformationList.isEmpty()) {
                    for (UnregisterInformation unregisterInformation : this.unregisterInformationList) {
                        this.removeBrigadierCommands(this.getBrigadierDispatcher().getRoot(), unregisterInformation.commandName(), unregisterInformation.unregisterNamespaces(), c -> !unregisterInformation.unregisterBukkit() ^ this.isBukkitCommand.test((CommandNode<Source>)c));
                    }
                    CommandAPIHandler.getInstance().writeDispatcherToFile();
                }
            })).priority(1));
        }
    }

    private void registerLifecycleEvent(LifecycleEventManager<?> lifecycleEventManager, CommandDispatcher<CommandSourceStack> dispatcher) {
        lifecycleEventManager.registerEventHandler((LifecycleEventHandlerConfiguration)((PrioritizedLifecycleEventHandlerConfiguration)LifecycleEvents.COMMANDS.newHandler(event -> {
            for (CommandNode commandNode : dispatcher.getRoot().getChildren()) {
                LiteralCommandNode node = (LiteralCommandNode)commandNode;
                ((Commands)event.registrar()).register(node, this.getDescription(node.getLiteral()));
            }
            for (String commandName : this.commandsToRemove) {
                this.removeBrigadierCommands(this.getBrigadierDispatcher().getRoot(), commandName, false, c -> true);
            }
            CommandAPIHandler.getInstance().writeDispatcherToFile();
        })).priority(2));
    }

    private void scheduleReloadTask() {
        if (CommandAPI.canRegister() || !this.scheduleReloadTask) {
            return;
        }
        this.scheduleReloadTask = false;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CommandAPIPaper.getPaper().getPlugin(), () -> {
            Bukkit.reloadData();
            this.scheduleReloadTask = true;
        }, 1L);
    }

    private String getDescription(String commandName) {
        String namespaceStripped = commandName.contains(":") ? commandName.split(":")[1] : commandName;
        for (RegisteredCommand command : CommandAPI.getRegisteredCommands()) {
            if (!command.commandName().equals(namespaceStripped) && !Arrays.asList(command.aliases()).contains(namespaceStripped)) continue;
            Object helpTopic = command.helpTopic().orElse(null);
            if (helpTopic != null) {
                return ((HelpTopic)helpTopic).getShortText();
            }
            return command.shortDescription().orElse("A command by the " + CommandAPIBukkit.getConfiguration().getPluginName() + " plugin.");
        }
        return "";
    }

    private record UnregisterInformation(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
    }
}

