/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.client.locatefeature.impl;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import eu.jacobsjo.util.ColorUtil;
import eu.jacobsjo.worldgendevtools.locatefeature.LocateFeatureInit;
import eu.jacobsjo.worldgendevtools.locatefeature.impl.FeaturePositions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_12021;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4668;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_863;
import net.minecraft.class_9974;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class LocationRenderer
implements class_863.class_864 {
    private static final int RANGE = 2;
    private static final RenderPipeline DEBUG_FILLED_BOX_SEE_THROUGH_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation(class_2960.method_60655((String)"worldgendevtools", (String)"pipeline/debug_filled_box_see_through")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
    private static final class_1921.class_4687 DEBUG_FILLED_BOX_SEE_THROUGH = class_1921.method_24049((String)"debug_filled_box", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)DEBUG_FILLED_BOX_SEE_THROUGH_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23607(class_4668.field_22241).method_23617(false));

    public void method_23109(class_4587 poseStack, class_4597 buffer, double d, double e, double f, class_12021 debugValueAccess, class_4604 frustum) {
        class_1297 player = class_310.method_1551().method_1560();
        if (player == null) {
            return;
        }
        class_243 playerPos = player.method_30950(0.0f);
        class_2338 playerBlockPos = class_2338.method_49638((class_2374)playerPos);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        int centerChunkX = class_4076.method_18675((int)playerBlockPos.method_10263());
        int centerChunkZ = class_4076.method_18675((int)playerBlockPos.method_10260());
        for (int x = centerChunkX - 2; x <= centerChunkX + 2; ++x) {
            for (int z = centerChunkZ - 2; z <= centerChunkZ + 2; ++z) {
                this.renderLocationsInChunk(poseStack, buffer, level, x, z, playerPos);
            }
        }
    }

    private void renderLocationsInChunk(class_4587 poseStack, class_4597 buffer, class_638 level, int chunkX, int chunkZ, class_243 playerPos) {
        class_2818 chunk = level.method_8497(chunkX, chunkZ);
        FeaturePositions featurePositions = (FeaturePositions)chunk.getAttached(LocateFeatureInit.FEATURE_POSITION_ATTACHMENT);
        if (featurePositions == null) {
            return;
        }
        Object2IntOpenHashMap posCounts = new Object2IntOpenHashMap();
        for (class_5321<class_2975<?, ?>> key : featurePositions.getFeatureTypes()) {
            List<FeaturePositions.PosAndCount> positions = featurePositions.getPositions(key);
            assert (positions != null);
            ColorUtil.RGB color = ColorUtil.randomFromString(key.method_29177().toString());
            positions.forEach(pos -> {
                if (pos.pos().method_46558().method_24802((class_2374)playerPos, 24.0)) {
                    int count = posCounts.getOrDefault((Object)pos.pos(), 0);
                    posCounts.put((Object)pos.pos(), count + 1);
                    if (count < 5) {
                        this.renderDebugBox(poseStack, buffer, pos.pos(), color.r(), color.g(), color.b(), count);
                    }
                    if (pos.pos().method_46558().method_24802((class_2374)playerPos, 8.0)) {
                        if (count < 6) {
                            LocationRenderer.renderFloatingText(poseStack, buffer, String.valueOf(key.method_29177()) + (String)(pos.count() > 1 ? " [x" + pos.count() + "]" : ""), (double)pos.pos().method_10263() + 0.5, (double)pos.pos().method_10264() + 0.5, (double)pos.pos().method_10260() + 0.5, color.asInt(), 0.015f, true, -20.0f - (float)count * 10.0f, true);
                        } else if (count == 6) {
                            LocationRenderer.renderFloatingText(poseStack, buffer, "[and more]", (double)pos.pos().method_10263() + 0.5, (double)pos.pos().method_10264() + 0.5, (double)pos.pos().method_10260() + 0.5, 0xD0D0D0, 0.015f, true, -20.0f - (float)count * 10.0f, true);
                        }
                    }
                }
            });
        }
    }

    private void renderDebugBox(class_4587 poseStack, class_4597 buffer, class_2338 pos, float red, float green, float blue, int count) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        if (camera.method_19332()) {
            class_243 vec3 = camera.method_19326().method_22882();
            class_238 aABB = new class_238(pos).method_997(vec3).method_1014(-0.4 - (double)count * 0.02);
            class_4588 vertexConsumer = buffer.method_73477((class_1921)DEBUG_FILLED_BOX_SEE_THROUGH);
            class_9974.method_62300((class_4587)poseStack, (class_4588)vertexConsumer, (double)aABB.field_1323, (double)aABB.field_1322, (double)aABB.field_1321, (double)aABB.field_1320, (double)aABB.field_1325, (double)aABB.field_1324, (float)red, (float)green, (float)blue, (float)1.0f);
        }
    }

    public static void renderFloatingText(class_4587 poseStack, class_4597 buffer, String text, double x, double y, double z, int color, float scale, boolean bl, float yOffset, boolean transparent) {
        class_310 minecraft = class_310.method_1551();
        class_4184 camera = minecraft.field_1773.method_19418();
        if (camera.method_19332()) {
            class_327 font = minecraft.field_1772;
            double d = camera.method_19326().field_1352;
            double e = camera.method_19326().field_1351;
            double g = camera.method_19326().field_1350;
            poseStack.method_22903();
            poseStack.method_46416((float)(x - d), (float)(y - e) + 0.07f, (float)(z - g));
            poseStack.method_22907((Quaternionfc)camera.method_23767());
            poseStack.method_22905(scale, -scale, scale);
            float h = bl ? (float)(-font.method_1727(text)) / 2.0f : 0.0f;
            font.method_27521(text, h, yOffset, 0xFF000000 | color, true, poseStack.method_23760().method_23761(), buffer, transparent ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
            poseStack.method_22909();
        }
    }
}

