/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.dfcommand.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import eu.jacobsjo.util.TextUtil;
import eu.jacobsjo.worldgendevtools.dfcommand.RandomState;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3754;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_7079;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public final class DfCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_DENSITY_FUNCTION = new DynamicCommandExceptionType(object -> TextUtil.translatable("worldgendevtools.dfcommand.density_function.invalid", object));
    private static final DynamicCommandExceptionType ERROR_NO_NOISE_ROUTER = new DynamicCommandExceptionType(objcet -> TextUtil.translatable("worldgendevtools.dfcommand.noise_router.no"));
    private static final Collection<String> NOISE_ROUTER_VALUES = Arrays.asList("barrier", "fluid_level_floodedness", "fluid_level_spread", "lava", "temperature", "vegetation", "continents", "erosion", "depth", "ridges", "preliminary_surface_level", "final_density", "vein_toggle", "vein_ridged", "vein_gap");

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        LiteralArgumentBuilder noiseRouterArgument = class_2170.method_9247((String)"noise_router");
        for (String value : NOISE_ROUTER_VALUES) {
            noiseRouterArgument = noiseRouterArgument.then(((LiteralArgumentBuilder)class_2170.method_9247((String)value).executes(commandContext -> DfCommand.getDensity((class_2168)commandContext.getSource(), value, class_2338.method_49638((class_2374)((class_2168)commandContext.getSource()).method_9222()), ((class_2168)commandContext.getSource()).method_9225()))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(commandContext -> DfCommand.getDensity((class_2168)commandContext.getSource(), value, class_2262.method_9696((CommandContext)commandContext, (String)"pos"), ((class_2168)commandContext.getSource()).method_9225()))));
        }
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"getdensity").then(class_2170.method_9247((String)"density_function").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"density_function", (ArgumentType)class_7079.method_41224((class_5321)class_7924.field_41240)).executes(commandContext -> DfCommand.getDensity((class_2168)commandContext.getSource(), DfCommand.getRegistryKeyType((CommandContext<class_2168>)commandContext, "density_function", class_7924.field_41240, ERROR_INVALID_DENSITY_FUNCTION), class_2338.method_49638((class_2374)((class_2168)commandContext.getSource()).method_9222()), ((class_2168)commandContext.getSource()).method_9225()))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(commandContext -> DfCommand.getDensity((class_2168)commandContext.getSource(), DfCommand.getRegistryKeyType((CommandContext<class_2168>)commandContext, "density_function", class_7924.field_41240, ERROR_INVALID_DENSITY_FUNCTION), class_2262.method_9696((CommandContext)commandContext, (String)"pos"), ((class_2168)commandContext.getSource()).method_9225())))))).then((ArgumentBuilder)noiseRouterArgument));
    }

    public static int getDensity(class_2168 commandSourceStack, String routerDensityFunction, class_2338 pos, class_3218 level) throws CommandSyntaxException {
        class_2794 chunkGenerator = level.method_14178().method_12129();
        if (chunkGenerator instanceof class_3754) {
            class_3754 noiseBasedChunkGenerator = (class_3754)chunkGenerator;
            class_6953 router = ((class_5284)noiseBasedChunkGenerator.method_41541().comp_349()).comp_477();
            class_6910 densityFunction = switch (routerDensityFunction) {
                case "barrier" -> router.comp_414();
                case "fluid_level_floodedness" -> router.comp_415();
                case "fluid_level_spread" -> router.comp_416();
                case "lava" -> router.comp_417();
                case "temperature" -> router.comp_420();
                case "vegetation" -> router.comp_539();
                case "continents" -> router.comp_484();
                case "erosion" -> router.comp_423();
                case "depth" -> router.comp_424();
                case "ridges" -> router.comp_485();
                case "preliminary_surface_level" -> router.comp_4450();
                case "final_density" -> router.comp_487();
                case "vein_toggle" -> router.comp_428();
                case "vein_ridged" -> router.comp_429();
                case "vein_gap" -> router.comp_430();
                default -> class_6916.method_40479();
            };
            return DfCommand.getDensity(commandSourceStack, densityFunction, pos, (class_5284)noiseBasedChunkGenerator.method_41541().comp_349(), level);
        }
        throw ERROR_NO_NOISE_ROUTER.create((Object)routerDensityFunction);
    }

    public static int getDensity(class_2168 commandSourceStack, class_6880<class_6910> densityFunctionHolder, class_2338 pos, class_3218 level) {
        class_2794 chunkGenerator = level.method_14178().method_12129();
        if (chunkGenerator instanceof class_3754) {
            class_3754 noiseBasedChunkGenerator = (class_3754)chunkGenerator;
            return DfCommand.getDensity(commandSourceStack, (class_6910)densityFunctionHolder.comp_349(), pos, (class_5284)noiseBasedChunkGenerator.method_41541().comp_349(), level);
        }
        return DfCommand.getDensity(commandSourceStack, (class_6910)densityFunctionHolder.comp_349(), pos, class_5284.method_44323(), level);
    }

    public static int getDensity(class_2168 commandSourceStack, class_6910 densityFunction, class_2338 pos, class_5284 generatorSettings, class_3218 level) {
        class_5455 registryAccess = level.method_30349();
        RandomState randomState = RandomState.create(generatorSettings, (class_7871<class_5216.class_5487>)registryAccess.method_46751(class_7924.field_41244), level.method_8412());
        double value = densityFunction.method_40469(randomState.getVisitor()).method_40464((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        DecimalFormat format = new DecimalFormat("0.000");
        commandSourceStack.method_9226(() -> TextUtil.translatable("worldgendevtools.dfcommand.result", format.format(value)), true);
        return (int)(value * 1000.0);
    }

    private static <T> class_5321<T> getRegistryType(CommandContext<class_2168> commandContext, String string, class_5321<class_2378<T>> resourceKey, DynamicCommandExceptionType dynamicCommandExceptionType) throws CommandSyntaxException {
        class_5321 resourceKey2 = (class_5321)commandContext.getArgument(string, class_5321.class);
        Optional optional = resourceKey2.method_39752(resourceKey);
        return (class_5321)optional.orElseThrow(() -> dynamicCommandExceptionType.create((Object)resourceKey2));
    }

    private static <T> class_2378<T> getRegistry(CommandContext<class_2168> commandContext, class_5321<? extends class_2378<T>> resourceKey) {
        return ((class_2168)commandContext.getSource()).method_9211().method_30611().method_30530(resourceKey);
    }

    private static <T> class_6880<T> getRegistryKeyType(CommandContext<class_2168> commandContext, String string, class_5321<class_2378<T>> resourceKey, DynamicCommandExceptionType dynamicCommandExceptionType) throws CommandSyntaxException {
        class_5321 resourceKey2 = DfCommand.getRegistryType(commandContext, string, resourceKey, dynamicCommandExceptionType);
        return (class_6880)DfCommand.getRegistry(commandContext, resourceKey).method_46746(resourceKey2).orElseThrow(() -> dynamicCommandExceptionType.create((Object)resourceKey2.method_29177().toString()));
    }
}

