/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.reloadregistries.mixin;

import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11897;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3449;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6749;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2791.class})
public class ChunkAccessMixin {
    @Shadow
    protected volatile boolean field_34537;
    @Shadow
    @Final
    private static LongSet field_37052;
    @Shadow
    @Final
    protected class_2826[] field_34545;
    @Unique
    private Map<class_2960, class_3449> structureStartsByLocation;
    @Unique
    private Map<class_2960, LongSet> structuresRefencesByLocation;
    @Unique
    private class_5455 registryAccess;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(class_1923 chunkPos, class_2843 upgradeData, class_5539 levelHeightAccessor, class_11897 palettedContainerFactory, long l, class_2826[] levelChunkSections, class_6749 blendingData, CallbackInfo ci) {
        if (levelHeightAccessor instanceof class_1937 && !((class_1937)levelHeightAccessor).method_8608()) {
            this.registryAccess = ((class_1937)levelHeightAccessor).method_30349();
            this.structureStartsByLocation = Maps.newHashMap();
            this.structuresRefencesByLocation = Maps.newHashMap();
        }
    }

    @Inject(method={"getStartForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void getStartForStructure(class_3195 structure, CallbackInfoReturnable<class_3449> cir) {
        if (this.registryAccess == null) {
            return;
        }
        cir.setReturnValue((Object)this.structureStartsByLocation.get(this.registryAccess.method_30530(class_7924.field_41246).method_10221((Object)structure)));
        cir.cancel();
    }

    @Inject(method={"setStartForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void setStartForStructure(class_3195 structure, class_3449 structureStart, CallbackInfo ci) {
        if (this.registryAccess == null) {
            return;
        }
        this.structureStartsByLocation.put(this.registryAccess.method_30530(class_7924.field_41246).method_10221((Object)structure), structureStart);
        this.field_34537 = true;
        ci.cancel();
    }

    @Inject(method={"getAllStarts"}, at={@At(value="HEAD")}, cancellable=true)
    public void getAllStarts(CallbackInfoReturnable<Map<class_3195, class_3449>> cir) {
        if (this.registryAccess == null) {
            return;
        }
        cir.setReturnValue(Collections.unmodifiableMap(this.structureStartsByLocation.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((class_3195)this.registryAccess.method_30530(class_7924.field_41246).method_63535((class_2960)e.getKey()), (class_3449)e.getValue()), HashMap::putAll)));
        cir.cancel();
    }

    @Inject(method={"setAllStarts"}, at={@At(value="HEAD")}, cancellable=true)
    public void setAllStarts(Map<class_3195, class_3449> structureStarts, CallbackInfo ci) {
        if (this.registryAccess == null) {
            return;
        }
        this.structureStartsByLocation.clear();
        structureStarts.forEach((structure, structureStart) -> this.structureStartsByLocation.put(this.registryAccess.method_30530(class_7924.field_41246).method_10221(structure), (class_3449)structureStart));
        this.field_34537 = true;
        ci.cancel();
    }

    @Inject(method={"getReferencesForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void getReferencesForStructure(class_3195 structure, CallbackInfoReturnable<LongSet> cir) {
        if (this.registryAccess == null) {
            return;
        }
        cir.setReturnValue((Object)this.structuresRefencesByLocation.getOrDefault(this.registryAccess.method_30530(class_7924.field_41246).method_10221((Object)structure), field_37052));
        cir.cancel();
    }

    @Inject(method={"addReferenceForStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void addReferenceForStructure(class_3195 structure, long reference, CallbackInfo ci) {
        if (this.registryAccess == null) {
            return;
        }
        this.structuresRefencesByLocation.computeIfAbsent(this.registryAccess.method_30530(class_7924.field_41246).method_10221((Object)structure), structurex -> new LongOpenHashSet()).add(reference);
        this.field_34537 = true;
        ci.cancel();
    }

    @Inject(method={"getAllReferences"}, at={@At(value="HEAD")}, cancellable=true)
    public void getAllReferences(CallbackInfoReturnable<Map<class_3195, LongSet>> cir) {
        if (this.registryAccess == null) {
            return;
        }
        cir.setReturnValue(Collections.unmodifiableMap(this.structuresRefencesByLocation.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<class_3195, LongSet>((class_3195)this.registryAccess.method_30530(class_7924.field_41246).method_63535((class_2960)e.getKey()), (LongSet)e.getValue())).filter(e -> e.getKey() != null).collect(HashMap::new, (m, e) -> m.put((class_3195)e.getKey(), (LongSet)e.getValue()), HashMap::putAll)));
        cir.cancel();
    }

    @Inject(method={"setAllReferences"}, at={@At(value="HEAD")}, cancellable=true)
    public void setAllReferences(Map<class_3195, LongSet> structureReferencesMap, CallbackInfo ci) {
        if (this.registryAccess == null) {
            return;
        }
        this.structuresRefencesByLocation.clear();
        structureReferencesMap.forEach((structure, reference) -> this.structuresRefencesByLocation.put(this.registryAccess.method_30530(class_7924.field_41246).method_10221(structure), (LongSet)reference));
        this.field_34537 = true;
        ci.cancel();
    }

    @ModifyExpressionValue(method={"getNoiseBiome"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkAccess;getSectionIndex(I)I")})
    public int getNoiseBiome(int original) {
        return Math.min(original, this.field_34545.length - 1);
    }
}

