/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.resetchunks.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import eu.jacobsjo.util.TextUtil;
import eu.jacobsjo.worldgendevtools.resetchunks.api.ResettableChunkMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import org.slf4j.Logger;

public class ResetChunksCommand {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resetchunks").requires(commandSourceStack -> commandSourceStack.method_9259(4))).executes(commandContext -> ResetChunksCommand.resetChunks((class_2168)commandContext.getSource(), 0))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8)).executes(commandContext -> ResetChunksCommand.resetChunks((class_2168)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"range")))));
    }

    private static int resetChunks(class_2168 source, int range) {
        int chunkCount = (range * 2 + 1) * (range * 2 + 1);
        class_3218 level = source.method_9225();
        class_3898 chunkMap = level.method_14178().field_17254;
        class_1923 centerChunkPos = new class_1923(class_2338.method_49638((class_2374)source.method_9222()));
        class_1923 minChunkPos = new class_1923(centerChunkPos.field_9181 - range, centerChunkPos.field_9180 - range);
        class_1923 maxChunkPos = new class_1923(centerChunkPos.field_9181 + range, centerChunkPos.field_9180 + range);
        class_238 aabb = new class_238((double)minChunkPos.method_8326(), (double)level.method_31607(), (double)minChunkPos.method_8328(), (double)maxChunkPos.method_8327(), (double)level.method_31600(), (double)maxChunkPos.method_8329());
        level.method_8390(class_1297.class, aabb, entity -> !(entity instanceof class_1657)).forEach(class_1297::method_31472);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                class_1923 chunkPos = new class_1923(centerChunkPos.field_9181 + x, centerChunkPos.field_9180 + z);
                boolean success = ((ResettableChunkMap)chunkMap).worldgenDevtools$resetChunk(chunkPos);
                if (success) continue;
                source.method_9213((class_2561)TextUtil.translatable("worldgendevtools.resetchunks.failed", chunkPos));
                return 0;
            }
        }
        source.method_9226(() -> TextUtil.translatable("worldgendevtools.resetchunks.success", chunkCount), true);
        return chunkCount;
    }
}

