/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.util;

public class ColorUtil {
    public static RGB hsvToRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        return switch (h) {
            case 0 -> new RGB(value, t, p);
            case 1 -> new RGB(q, value, p);
            case 2 -> new RGB(p, value, t);
            case 3 -> new RGB(p, q, value);
            case 4 -> new RGB(t, p, value);
            default -> new RGB(value, p, q);
        };
    }

    public static RGB randomFromString(String str) {
        int hash = str.hashCode();
        float h = (float)(hash & 0xFF) / 255.0f;
        float s = (float)(hash >> 8 & 0xFF) / 255.0f / 2.0f + 0.5f;
        float v = (float)(hash >> 16 & 0xFF) / 255.0f / 2.0f + 0.5f;
        return ColorUtil.hsvToRgb(h, s, v);
    }

    public record RGB(float r, float g, float b) {
        public int asInt() {
            return ((int)(this.r * 256.0f) & 0xFF) << 16 | ((int)(this.g * 256.0f) & 0xFF) << 8 | (int)(this.b * 256.0f) & 0xFF;
        }
    }
}

