/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.client.datapackadding.impl;

import com.mojang.logging.LogUtils;
import eu.jacobsjo.worldgendevtools.client.datapackadding.api.ExtendablePathAllowList;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_8580;
import net.minecraft.class_8582;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class SymlinkUtil {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final class_370.class_9037 ADD_SYMLINK_TOAST = new class_370.class_9037();

    public static void symlinkPacks(class_310 minecraft, List<Path> packs, Path outDir) {
        MutableBoolean mutableBoolean = new MutableBoolean();
        packs.forEach(path -> {
            try {
                Files.createSymbolicLink(outDir.resolve(path.getFileName()), path, new FileAttribute[0]);
            }
            catch (IOException | UnsupportedOperationException e) {
                LOGGER.warn("Failed to symlink datapack file from {} to {}", path, (Object)outDir);
                mutableBoolean.setTrue();
            }
        });
        if (mutableBoolean.isTrue()) {
            class_370.method_29627((class_310)minecraft, (String)outDir.toString());
        }
    }

    public static void addAllowedSymlink(class_310 minecraft, Path path) {
        LOGGER.info("Adding allowed symlink to {}", (Object)path);
        class_8580 datapackValidator = minecraft.method_52702();
        if (!(datapackValidator.field_44955 instanceof class_8582)) {
            datapackValidator.field_44955 = new class_8582(new ArrayList());
        }
        ((ExtendablePathAllowList)((Object)minecraft.method_52702().field_44955)).worldgenDevtools$addEntry(new class_8582.class_8583(class_8582.class_8584.field_44962, "glob:" + path.toString()));
        Path allowedSymlinkPath = minecraft.field_1697.toPath().resolve("allowed_symlinks.txt");
        try (FileWriter fw = new FileWriter(allowedSymlinkPath.toString(), true);){
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(String.format("%n[glob]%s", path.toAbsolutePath()));
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save allowed symlink", (Throwable)e);
        }
        class_370.method_27024((class_374)minecraft.method_1566(), (class_370.class_9037)ADD_SYMLINK_TOAST, (class_2561)class_2561.method_43471((String)"worldgendevtools.datapackadding.gui.symlink.add_allowed"), (class_2561)class_2561.method_43470((String)path.toString()));
    }
}

