/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.client.locatefeature.impl;

import eu.jacobsjo.util.ColorUtil;
import eu.jacobsjo.worldgendevtools.locatefeature.LocateFeatureInit;
import eu.jacobsjo.worldgendevtools.locatefeature.impl.FeaturePositions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_12021;
import net.minecraft.class_12179;
import net.minecraft.class_12180;
import net.minecraft.class_12187;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_2975;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4604;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_863;

@Environment(value=EnvType.CLIENT)
public class LocationRenderer
implements class_863.class_864 {
    private static final int RANGE = 2;

    public void method_23109(double d, double e, double f, class_12021 debugValueAccess, class_4604 frustum, float g) {
        class_1297 player = class_310.method_1551().method_1560();
        if (player == null) {
            return;
        }
        class_243 playerPos = player.method_30950(0.0f);
        class_2338 playerBlockPos = class_2338.method_49638((class_2374)playerPos);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        int centerChunkX = class_4076.method_18675((int)playerBlockPos.method_10263());
        int centerChunkZ = class_4076.method_18675((int)playerBlockPos.method_10260());
        for (int x = centerChunkX - 2; x <= centerChunkX + 2; ++x) {
            for (int z = centerChunkZ - 2; z <= centerChunkZ + 2; ++z) {
                this.renderLocationsInChunk(level, x, z, playerPos);
            }
        }
    }

    private void renderLocationsInChunk(class_638 level, int chunkX, int chunkZ, class_243 playerPos) {
        class_2818 chunk = level.method_8497(chunkX, chunkZ);
        FeaturePositions featurePositions = (FeaturePositions)chunk.getAttached(LocateFeatureInit.FEATURE_POSITION_ATTACHMENT);
        if (featurePositions == null) {
            return;
        }
        Object2IntOpenHashMap posCounts = new Object2IntOpenHashMap();
        for (class_5321<class_2975<?, ?>> key : featurePositions.getFeatureTypes()) {
            List<FeaturePositions.PosAndCount> positions = featurePositions.getPositions(key);
            assert (positions != null);
            ColorUtil.RGB color = ColorUtil.randomFromString(key.method_29177().toString());
            positions.forEach(pos -> {
                if (pos.pos().method_46558().method_24802((class_2374)playerPos, 24.0)) {
                    int count = posCounts.getOrDefault((Object)pos.pos(), 0);
                    posCounts.put((Object)pos.pos(), count + 1);
                    if (count < 5) {
                        int alpha = 255 / (count + 1);
                        class_12180.method_75549((class_2338)pos.pos(), (float)-0.4f, (class_12179)class_12179.method_75539((int)(alpha << 24 | color.asInt()))).method_75533();
                    }
                    if (pos.pos().method_46558().method_24802((class_2374)playerPos, 8.0) && count <= 6) {
                        String text = count == 6 ? "[and more]" : String.valueOf(key.method_29177()) + (String)(pos.count() > 1 ? " [x" + pos.count() + "]" : "");
                        class_12180.method_75551((String)text, (class_243)pos.pos().method_46558().method_1031(0.0, 0.28 + 0.13 * (double)count, 0.0), (class_12187.class_12188)class_12187.class_12188.method_75566((int)(0xFF000000 | color.asInt())).method_75565(0.2f)).method_75533();
                    }
                }
            });
        }
    }
}

