/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.profiling.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.jacobsjo.util.TextUtil;
import eu.jacobsjo.worldgendevtools.profiling.ProfilingInit;
import eu.jacobsjo.worldgendevtools.profiling.impl.ChunkgenProfilingInformation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class ChunkProfilingCommand {
    public static final int HEADER_COLOR = 0x80FF80;
    public static final int KEY_COLOR = 0x8080FF;
    public static final int NUMBER_COLOR = 0xFFFFFF;
    public static final int TEXT_COLOR = 0xA0A0A0;

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chunkprofiling").executes(commandContext -> ChunkProfilingCommand.getProfiling((class_2168)commandContext.getSource(), 0))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8)).executes(commandContext -> ChunkProfilingCommand.getProfiling((class_2168)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"range")))));
    }

    public static int getProfiling(class_2168 source, int range) {
        class_1923 centerChunkPos = new class_1923(class_2338.method_49638((class_2374)source.method_9222()));
        ArrayList<ChunkgenProfilingInformation> informations = new ArrayList<ChunkgenProfilingInformation>();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                class_2818 chunk = source.method_9225().method_8497(centerChunkPos.field_9181 + x, centerChunkPos.field_9180 + z);
                ChunkgenProfilingInformation info = (ChunkgenProfilingInformation)chunk.getAttached(ProfilingInit.PROFILING_ATTACHMENT);
                if (info == null) continue;
                informations.add(info);
            }
        }
        if (informations.isEmpty()) {
            source.method_9213((class_2561)TextUtil.translatable("worldgendevtools.profiling.command.no_information"));
            return 0;
        }
        ChunkgenProfilingInformation sum = ChunkgenProfilingInformation.sum(informations);
        class_5250 message = class_2561.method_43470((String)"");
        int chunkCount = informations.size();
        if (chunkCount == 1) {
            message.method_10852((class_2561)TextUtil.translatable("worldgendevtools.profiling.command.header.one", centerChunkPos.toString()).method_54663(0x80FF80));
        } else {
            message.method_10852((class_2561)TextUtil.translatable("worldgendevtools.profiling.command.header", chunkCount).method_54663(0x80FF80));
        }
        class_7923.field_41184.method_29722().stream().filter(e -> !((class_2806)e.getValue()).equals(class_2806.field_12798)).sorted(Comparator.comparingInt(e -> ((class_2806)e.getValue()).method_16559())).map(e -> ((class_5321)e.getKey()).method_29177()).forEach(loc -> {
            Duration duration = sum.getStatusDuration((class_2960)loc);
            Duration average = duration.dividedBy(informations.size());
            message.method_27693("\n");
            message.method_10852((class_2561)TextUtil.translatable("worldgendevtools.profiling.command.entry.key", loc.method_12832()).method_54663(0x8080FF));
            if (chunkCount == 1) {
                message.method_10852((class_2561)TextUtil.translatable("worldgendevtools.profiling.command.entry.value.single", class_2561.method_43470((String)String.format("%.2f", (double)duration.toNanos() * 1.0E-6)).method_54663(0xFFFFFF)).method_54663(0xA0A0A0));
            } else {
                message.method_10852((class_2561)TextUtil.translatable("worldgendevtools.profiling.command.entry.value", class_2561.method_43470((String)String.format("%.2f", (double)average.toNanos() * 1.0E-6)).method_54663(0xFFFFFF), class_2561.method_43470((String)String.format("%.2f", (double)duration.toNanos() * 1.0E-6)).method_54663(0xFFFFFF)).method_54663(0xA0A0A0));
            }
        });
        source.method_9226(() -> message, true);
        return 1;
    }
}

