/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.locatefeature.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2975;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class FeaturePositions {
    public static final Codec<FeaturePositions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(PositionsOfFeature.CODEC).fieldOf("positions").forGetter(FeaturePositions::getList)).apply((Applicative)instance, FeaturePositions::new));
    public static final class_9139<class_9129, FeaturePositions> STREAM_CODEC = class_9139.method_56434((class_9139)PositionsOfFeature.STREAM_CODEC.method_56433(class_9135.method_56363()), FeaturePositions::getList, FeaturePositions::new);
    private final Map<class_5321<class_2975<?, ?>>, List<PosAndCount>> featurePositions = new HashMap();

    public FeaturePositions() {
    }

    private FeaturePositions(List<PositionsOfFeature> positions) {
        positions.forEach(pos -> this.featurePositions.put(pos.feature, new ArrayList<PosAndCount>(pos.positions)));
    }

    private List<PositionsOfFeature> getList() {
        return this.featurePositions.entrySet().stream().map(entry -> new PositionsOfFeature((class_5321)entry.getKey(), (List)entry.getValue())).toList();
    }

    public void addPosiition(class_5321<class_2975<?, ?>> feature, class_2338 pos) {
        List positions = this.featurePositions.computeIfAbsent(feature, f -> new ArrayList());
        Optional<PosAndCount> posAndCount = positions.stream().filter(p -> p.pos().equals((Object)pos)).findAny();
        if (posAndCount.isPresent()) {
            posAndCount.get().increaseCount();
        } else {
            positions.add(new PosAndCount(pos, 1));
        }
    }

    public List<PosAndCount> getPositions(class_5321<class_2975<?, ?>> feature) {
        return this.featurePositions.getOrDefault(feature, List.of());
    }

    public Set<class_5321<class_2975<?, ?>>> getFeatureTypes() {
        return this.featurePositions.keySet();
    }

    public static final class PosAndCount {
        private static final Codec<Either<PosAndCount, class_2338>> EITHER_CODEC = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(i -> i.pos), (App)class_5699.field_33442.fieldOf("count").forGetter(i -> i.count)).apply((Applicative)instance, PosAndCount::new)), (Codec)class_2338.field_25064);
        private static final Codec<PosAndCount> CODEC = EITHER_CODEC.xmap(either -> (PosAndCount)either.map(o -> o, pos -> new PosAndCount((class_2338)pos, 1)), posAndCount -> posAndCount.count == 1 ? Either.right((Object)posAndCount.pos) : Either.left((Object)posAndCount));
        private static final class_9139<class_9129, PosAndCount> STREAM_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, PosAndCount::pos, (class_9139)class_9135.field_49675, PosAndCount::count, PosAndCount::new);
        private final class_2338 pos;
        private int count;

        public PosAndCount(class_2338 pos, int count) {
            this.pos = pos;
            this.count = count;
        }

        public class_2338 pos() {
            return this.pos;
        }

        public int count() {
            return this.count;
        }

        public void increaseCount() {
            ++this.count;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PosAndCount that = (PosAndCount)obj;
            return Objects.equals(this.pos, that.pos) && this.count == that.count;
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.count);
        }

        public String toString() {
            return "PosAndCount[pos=" + String.valueOf(this.pos) + ", count=" + this.count + "]";
        }
    }

    private record PositionsOfFeature(class_5321<class_2975<?, ?>> feature, List<PosAndCount> positions) {
        private static final Codec<PositionsOfFeature> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41239).fieldOf("feature").forGetter(i -> i.feature), (App)Codec.list(PosAndCount.CODEC).fieldOf("positions").forGetter(i -> i.positions)).apply((Applicative)instance, PositionsOfFeature::new));
        private static final class_9139<class_9129, PositionsOfFeature> STREAM_CODEC = class_9139.method_56435((class_9139)class_5321.method_56038((class_5321)class_7924.field_41239), PositionsOfFeature::feature, (class_9139)PosAndCount.STREAM_CODEC.method_56433(class_9135.method_56363()), PositionsOfFeature::positions, PositionsOfFeature::new);
    }
}

