/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.reloadregistries.impl;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import eu.jacobsjo.util.TextUtil;
import eu.jacobsjo.worldgendevtools.reloadregistries.api.ReloadableRegistry;
import eu.jacobsjo.worldgendevtools.reloadregistries.api.UpdatableGeneratorChunkMap;
import eu.jacobsjo.worldgendevtools.reloadregistries.impl.ComponentFormattedException;
import eu.jacobsjo.worldgendevtools.reloadregistries.impl.FrozenHolder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3242;
import net.minecraft.class_3244;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3754;
import net.minecraft.class_3898;
import net.minecraft.class_5250;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6860;
import net.minecraft.class_6861;
import net.minecraft.class_6903;
import net.minecraft.class_7655;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RegistryReloader {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final int REGISTRY_COLOR = 0x80FF80;
    public static final int ELEMENT_COLOR = 0x8080FF;
    public static final int ERROR_COLOR = 0xFF8080;

    public static void reloadRegistries(class_7780<class_7659> registries, Map<class_5321<class_1937>, class_3218> levels, ImmutableList<class_3262> resources) {
        LOGGER.info("Reloading registries");
        class_6861 resourceManager = new class_6861(class_3264.field_14190, resources);
        class_5455.class_6890 dimensionsContextLayer = registries.method_45935((Object)class_7659.field_39973);
        class_5455.class_6890 dimensionsNewLayer = registries.method_45928((Object)class_7659.field_39973);
        class_6903.class_7863 dimensionsLookup = RegistryReloader.getRegistrtyInfoLookup(dimensionsContextLayer, dimensionsNewLayer, false);
        HashMap generators = new HashMap();
        levels.forEach((key, level) -> generators.put(key.method_29177(), (JsonElement)class_2794.field_24746.encodeStart((DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)dimensionsLookup), (Object)level.method_14178().method_12129()).getOrThrow()));
        HashMap exceptionMap = new HashMap();
        class_5455.class_6890 worldgenContextLayer = registries.method_45935((Object)class_7659.field_39972);
        class_5455.class_6890 worldgenNewLayer = registries.method_45928((Object)class_7659.field_39972);
        class_6903.class_7863 worldgenLookup = RegistryReloader.getRegistrtyInfoLookup(worldgenContextLayer, worldgenNewLayer, true);
        class_7655.field_39968.forEach(arg_0 -> RegistryReloader.lambda$reloadRegistries$1(worldgenLookup, (class_6860)resourceManager, worldgenNewLayer, exceptionMap, arg_0));
        ArrayList<IllegalStateException> freezingExceptions = new ArrayList<IllegalStateException>();
        class_7655.field_39968.forEach(data -> {
            try {
                class_2378 registry = worldgenNewLayer.method_30530(data.comp_985());
                registry.method_40276();
            }
            catch (IllegalStateException e) {
                freezingExceptions.add(e);
            }
        });
        if (!exceptionMap.isEmpty()) {
            RegistryReloader.logErrors(exceptionMap);
            resourceManager.close();
            throw new ComponentFormattedException(RegistryReloader.formatErrors(exceptionMap));
        }
        if (!freezingExceptions.isEmpty()) {
            resourceManager.close();
            throw new ComponentFormattedException(RegistryReloader.formatFreezingErrors(freezingExceptions));
        }
        class_2370 levelStemRegistry = new class_2370(class_7924.field_41224, Lifecycle.stable());
        class_7655.method_45122((class_3300)resourceManager, (class_6903.class_7863)dimensionsLookup, (class_2385)levelStemRegistry, (Decoder)class_5363.field_25411, exceptionMap);
        Stream<class_2960> dimensionKeys = Stream.concat(levelStemRegistry.method_42021().stream().map(class_5321::method_29177), generators.keySet().stream()).distinct();
        dimensionKeys.forEach(key -> {
            class_2794 chunkGenerator;
            LOGGER.info("Reloading dimension: {}", key);
            class_3218 level = (class_3218)levels.get(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)key));
            if (level == null) {
                LOGGER.warn("adding new dimension not supported; trying to add {}", key);
                return;
            }
            Optional levelStem = levelStemRegistry.method_17966(key);
            if (levelStem.isPresent()) {
                if (level.method_8597().comp_651() != ((class_2874)((class_5363)levelStem.get()).comp_1012().comp_349()).comp_651() || level.method_8597().comp_652() != ((class_2874)((class_5363)levelStem.get()).comp_1012().comp_349()).comp_652()) {
                    throw new IllegalStateException("Can't change world height of dimension " + String.valueOf(key) + ". Requires reloading the world.");
                }
                level.field_36402 = new FrozenHolder(((class_5363)levelStem.get()).comp_1012());
                chunkGenerator = ((class_5363)levelStem.get()).comp_1013();
            } else {
                chunkGenerator = (class_2794)class_2794.field_24746.parse((DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)worldgenLookup), (Object)((JsonElement)generators.get(key))).result().orElseThrow();
            }
            class_3898 chunkMap = level.method_14178().field_17254;
            class_2794 patt0$temp = chunkMap.method_37897();
            if (patt0$temp instanceof class_3754) {
                class_3754 oldNoiseGenerator = (class_3754)patt0$temp;
                if (chunkGenerator instanceof class_3754) {
                    class_3754 newNoiseGenerator = (class_3754)chunkGenerator;
                    if (!((class_5284)oldNoiseGenerator.method_41541().comp_349()).comp_474().equals((Object)((class_5284)newNoiseGenerator.method_41541().comp_349()).comp_474())) {
                        throw new IllegalStateException("Can't change generator of dimension " + String.valueOf(key) + ": Uses different generation shapes in noise settings. Requires reloading the world.");
                    }
                }
            } else if (chunkGenerator instanceof class_3754) {
                throw new IllegalStateException("Can't change generator of dimension " + String.valueOf(key) + ": should now be NoiseBasedChunkGenerator. Requires reloading the world.");
            }
            ((UpdatableGeneratorChunkMap)chunkMap).worldgenDevtools$setGenerator(chunkGenerator);
        });
    }

    public static void syncClient(class_3242 serverConnection) {
        for (class_2535 connection : serverConnection.method_37909()) {
            class_2547 var5 = connection.method_10744();
            if (!(var5 instanceof class_3244)) continue;
            class_3244 impl = (class_3244)var5;
            ServerPlayNetworking.reconfigure((class_3244)impl);
        }
    }

    private static <T> void loadData(class_6903.class_7863 registryInfoLookup, class_3300 resourceManager, class_7655.class_7657<T> data, class_5455.class_6890 layer, Map<class_5321<?>, Exception> exceptionMap) {
        Optional registry = layer.method_46759(data.comp_985());
        if (registry.isEmpty()) {
            exceptionMap.put(data.comp_985(), new Exception("Registry doesn't exist"));
            return;
        }
        if (!(registry.get() instanceof class_2385)) {
            exceptionMap.put(data.comp_985(), new Exception("Registry is not writable"));
            return;
        }
        class_7655.method_45122((class_3300)resourceManager, (class_6903.class_7863)registryInfoLookup, (class_2385)((class_2385)registry.get()), (Decoder)data.comp_986(), exceptionMap);
    }

    private static <T> class_6903.class_7862<T> createInfoForNewRegistry(class_2385<T> writableRegistry) {
        return new class_6903.class_7862(writableRegistry, writableRegistry.method_46769(), writableRegistry.method_46766());
    }

    private static <T> class_6903.class_7862<T> createInfoForContextRegistry(class_2378<T> registry) {
        return new class_6903.class_7862(registry, registry, registry.method_46766());
    }

    private static class_6903.class_7863 getRegistrtyInfoLookup(class_5455.class_6890 contextLayer, class_5455.class_6890 newLayer, boolean reset) {
        final HashMap lookupMap = new HashMap();
        contextLayer.method_40311().forEach(registryEntry -> lookupMap.put(registryEntry.comp_350(), RegistryReloader.createInfoForContextRegistry(registryEntry.comp_351())));
        newLayer.method_40311().forEach(registryEntry -> {
            assert (registryEntry.comp_351() instanceof class_2370);
            class_2370 registry = (class_2370)registryEntry.comp_351();
            if (reset) {
                ((ReloadableRegistry)registry).worldgenDevtools$startReload();
                lookupMap.put(registryEntry.comp_350(), RegistryReloader.createInfoForNewRegistry(registry));
            } else {
                lookupMap.put(registryEntry.comp_350(), RegistryReloader.createInfoForContextRegistry(registryEntry.comp_351()));
            }
        });
        return new class_6903.class_7863(){

            @NotNull
            public <E> Optional<class_6903.class_7862<E>> method_46623(class_5321<? extends class_2378<? extends E>> resourceKey) {
                return Optional.ofNullable((class_6903.class_7862)lookupMap.get(resourceKey));
            }
        };
    }

    private static void logErrors(Map<class_5321<?>, Exception> map) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Map<class_2960, Map<class_2960, Exception>> map2 = map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((class_5321)entry.getKey()).method_41185(), Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue)));
        map2.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            printWriter.printf("> Errors in registry %s:%n", entry.getKey());
            ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entryx -> {
                printWriter.printf(">> Errors in element %s:%n", entryx.getKey());
                ((Exception)entryx.getValue()).printStackTrace(printWriter);
            });
        });
        printWriter.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)stringWriter);
    }

    private static class_2561 formatErrors(Map<class_5321<?>, Exception> map) {
        class_5250 component = class_2561.method_43473();
        Map<class_2960, Map<class_2960, Exception>> map2 = map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((class_5321)entry.getKey()).method_41185(), Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue)));
        map2.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            component.method_10852((class_2561)TextUtil.translatable("worldgendevtools.reloadregistries.error.registry", ((class_2960)entry.getKey()).toString()).method_54663(0x80FF80));
            ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entryx -> {
                component.method_10852((class_2561)TextUtil.translatable("worldgendevtools.reloadregistries.error.element", ((class_2960)entryx.getKey()).toString()).method_54663(0x8080FF));
                component.method_10852((class_2561)class_2561.method_43470((String)(((Exception)entryx.getValue()).getCause().getMessage() + "\n")).method_54663(0xFF8080));
            });
        });
        return component;
    }

    private static class_2561 formatFreezingErrors(List<IllegalStateException> list) {
        class_5250 component = class_2561.method_43473();
        list.forEach(e -> component.method_10852((class_2561)class_2561.method_43470((String)(e.getMessage() + "\n")).method_54663(0xFF8080)));
        return component;
    }

    private static /* synthetic */ void lambda$reloadRegistries$1(class_6903.class_7863 worldgenLookup, class_6860 resourceManager, class_5455.class_6890 worldgenNewLayer, Map exceptionMap, class_7655.class_7657 data) {
        RegistryReloader.loadData(worldgenLookup, (class_3300)resourceManager, data, worldgenNewLayer, exceptionMap);
    }
}

