/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.reloadregistries.mixin;

import com.mojang.serialization.Lifecycle;
import eu.jacobsjo.worldgendevtools.reloadregistries.api.OutdatedHolder;
import eu.jacobsjo.worldgendevtools.reloadregistries.api.ReloadableRegistry;
import eu.jacobsjo.worldgendevtools.reloadregistries.impl.RegistryReloader;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7876;
import net.minecraft.class_9248;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2370.class})
public abstract class MappedRegistryMixin<T>
implements ReloadableRegistry {
    @Shadow
    @Final
    private ObjectList<class_6880.class_6883<T>> field_26682;
    @Shadow
    @Final
    private Reference2IntMap<T> field_26683;
    @Shadow
    @Final
    private Map<class_2960, class_6880.class_6883<T>> field_11107;
    @Shadow
    @Final
    private Map<class_5321<T>, class_6880.class_6883<T>> field_25067;
    @Shadow
    @Final
    private Map<T, class_6880.class_6883<T>> field_36461;
    @Shadow
    private boolean field_36463;
    @Shadow
    @Nullable
    private Map<T, class_6880.class_6883<T>> field_40584;
    @Shadow
    @Final
    private class_5321<? extends class_2378<T>> field_41126;
    @Shadow
    private Lifecycle field_26732;
    @Shadow
    @Final
    private Map<class_5321<T>, class_9248> field_49135;
    @Shadow
    class_2370.class_10105<T> field_53687;
    @Unique
    private boolean reloading = false;
    @Unique
    private Set<class_5321<T>> outdatedKeys = new HashSet<class_5321<T>>();
    @Unique
    private final Set<class_5321<T>> requiredNewKeys = new HashSet<class_5321<T>>();

    @Shadow
    @Nullable
    public abstract T method_29107(@Nullable class_5321<T> var1);

    @Shadow
    public abstract int method_10206(@Nullable T var1);

    @Shadow
    public abstract Optional<class_6880.class_6883<T>> method_46746(class_5321<T> var1);

    @Shadow
    public abstract class_5321<? extends class_2378<T>> method_46765();

    @Override
    public void worldgenDevtools$startReload() {
        if (this.field_40584 != null) {
            throw new IllegalStateException("Trying to reload registry " + this.field_41126.toString() + " which has intrusive holders.");
        }
        this.field_25067.entrySet().removeIf(entry -> !((class_6880.class_6883)entry.getValue()).method_40227());
        this.outdatedKeys = new HashSet<class_5321<T>>(this.field_25067.keySet());
        this.requiredNewKeys.clear();
        this.field_36463 = false;
        this.reloading = true;
        this.field_53687 = class_2370.class_10105.method_62697();
    }

    @Inject(method={"method_40276()Lnet/minecraft/class_2378;"}, at={@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V", shift=At.Shift.AFTER)})
    public void freeze(CallbackInfoReturnable<class_2378<T>> cir) {
        if (this.reloading) {
            this.reloading = false;
            this.outdatedKeys.forEach(key -> {
                RegistryReloader.LOGGER.info("Outdated element {} remains in registry", key);
                class_6880.class_6883<T> holder = this.method_46746((class_5321<T>)key).orElseThrow();
                ((OutdatedHolder)holder).worldgenDevtools$markOutdated(true);
            });
            if (!this.requiredNewKeys.isEmpty()) {
                throw new IllegalStateException("References remain to outdated keys from registry " + String.valueOf(this.method_46765()) + ": " + String.valueOf(this.requiredNewKeys));
            }
        }
    }

    @Inject(method={"method_10272(Lnet/minecraft/class_5321;Ljava/lang/Object;Lnet/minecraft/class_9248;)Lnet/minecraft/class_6880$class_6883;"}, at={@At(value="HEAD")}, cancellable=true)
    public void register(class_5321<T> key, T value, class_9248 registrationInfo, CallbackInfoReturnable<class_6880.class_6883<T>> cir) {
        if (this.reloading && this.field_11107.containsKey(key.method_29177())) {
            this.outdatedKeys.remove(key);
            this.requiredNewKeys.remove(key);
            T oldValue = this.method_29107(key);
            int id = this.method_10206(oldValue);
            this.field_26683.remove(oldValue, id);
            this.field_36461.remove(oldValue);
            if (this.field_36461.containsKey(value)) {
                class_156.method_22320((Throwable)new IllegalStateException("Adding duplicate value '" + String.valueOf(value) + "' to registry"));
            }
            class_6880.class_6883 reference = this.field_25067.computeIfAbsent(key, resourceKeyx -> class_6880.class_6883.method_40234((class_7876)((class_2370)this), (class_5321)resourceKeyx));
            ((OutdatedHolder)reference).worldgenDevtools$markOutdated(false);
            this.field_25067.put(key, reference);
            this.field_11107.put(key.method_29177(), reference);
            this.field_36461.put(value, reference);
            this.field_26682.set(id, (Object)reference);
            this.field_26683.put(value, id);
            this.field_49135.put(key, registrationInfo);
            this.field_26732 = this.field_26732.add(registrationInfo.comp_2355());
            cir.setReturnValue((Object)reference);
            cir.cancel();
        }
    }

    @Inject(method={"method_44298(Lnet/minecraft/class_5321;)Lnet/minecraft/class_6880$class_6883;"}, at={@At(value="RETURN")})
    public void getOrCreateHolderOrThrow(class_5321<T> key, CallbackInfoReturnable<class_6880.class_6883<T>> cir) {
        if (this.outdatedKeys.contains(key)) {
            this.outdatedKeys.remove(key);
            this.requiredNewKeys.add(key);
        }
    }

    @Overwrite
    public Optional<class_6880.class_6883<T>> method_10240(class_5819 random) {
        return class_156.method_40083(this.field_26682.stream().filter(holder -> !((OutdatedHolder)holder).worldgenDevtools$isOutdated()).toList(), (class_5819)random);
    }
}

