/*
 * Decompiled with CFR 0.152.
 */
package eu.jacobsjo.worldgendevtools.locatefeature.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import eu.jacobsjo.util.TextUtil;
import eu.jacobsjo.worldgendevtools.locatefeature.LocateFeatureInit;
import eu.jacobsjo.worldgendevtools.locatefeature.impl.FeaturePositions;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7079;
import net.minecraft.class_7924;
import org.slf4j.Logger;

public class LocateFeature {
    private static final int MAX_RANGE = 10;
    private static final Logger LOGGER = LogUtils.getLogger();

    public static LiteralArgumentBuilder<class_2168> addSubcommand(LiteralArgumentBuilder<class_2168> command) {
        return (LiteralArgumentBuilder)command.then(class_2170.method_9247((String)"feature").then(class_2170.method_9244((String)"configured_feature", (ArgumentType)class_7079.method_41224((class_5321)class_7924.field_41239)).executes(commandContext -> LocateFeature.locateFeature((class_2168)commandContext.getSource(), class_7079.method_41225((CommandContext)commandContext, (String)"configured_feature").method_40237()))));
    }

    public static int locateFeature(class_2168 source, class_5321<class_2975<?, ?>> feature) {
        try {
            class_2338 sourcePos = class_2338.method_49638((class_2374)source.method_9222());
            class_2791 chunk = source.method_9225().method_22350(sourcePos);
            FeaturePositions featurePositions = (FeaturePositions)chunk.getAttached(LocateFeatureInit.FEATURE_POSITION_ATTACHMENT);
            if (featurePositions == null) {
                source.method_9213((class_2561)TextUtil.translatable("worldgendevtools.locatefeature.command.failure.no_attachment"));
                return 0;
            }
            List<class_2338> positions = featurePositions.getPositions(feature);
            if (positions.isEmpty()) {
                return LocateFeature.locateNearbyFeature(source, feature, sourcePos, chunk.method_12004());
            }
            return LocateFeature.showListResult(source, feature.method_29177(), positions, sourcePos);
        }
        catch (Exception e) {
            LOGGER.error("Exception running command", (Throwable)e);
            throw e;
        }
    }

    public static int locateNearbyFeature(class_2168 source, class_5321<class_2975<?, ?>> feature, class_2338 sourcePos, class_1923 centerChunkPos) {
        for (int range = 1; range <= 10; ++range) {
            Stream<class_2338> foundPositions = Stream.empty();
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    class_2791 chunk;
                    FeaturePositions featurePositions;
                    if (Math.abs(x) < range && Math.abs(z) < range || (featurePositions = (FeaturePositions)(chunk = source.method_9225().method_22342(centerChunkPos.field_9181 + x, centerChunkPos.field_9180 + z, class_2806.field_12798)).getAttached(LocateFeatureInit.FEATURE_POSITION_ATTACHMENT)) == null) continue;
                    foundPositions = Stream.concat(foundPositions, featurePositions.getPositions(feature).stream());
                }
            }
            Optional<class_2338> minPos = foundPositions.min(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)sourcePos)));
            if (!minPos.isPresent()) continue;
            return LocateFeature.showLocateResult(source, feature.method_29177(), minPos.get(), sourcePos);
        }
        source.method_9213((class_2561)TextUtil.translatable("worldgendevtools.locatefeature.command.failure.not_nearby", feature.method_29177().toString()));
        return -1;
    }

    private static int showListResult(class_2168 source, class_2960 location, List<class_2338> positions, class_2338 sourcePos) {
        List<class_2338> sortedPositions = positions.stream().sorted(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)sourcePos))).limit(5L).toList();
        class_2561 positionsComponent = class_2564.method_37112(sortedPositions.stream().map(pos -> class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()})).method_27694(style -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/tp @s " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.coordinates.tooltip"))))).toList(), (class_2561)class_2561.method_43470((String)", "));
        String translationKey = positions.size() == 1 ? "single" : (positions.size() <= 5 ? "multiple" : "many");
        source.method_9226(() -> TextUtil.translatable("worldgendevtools.locatefeature.command.success." + translationKey, location.toString(), positions.size(), positionsComponent, positions.size() - 5), true);
        return (int)Math.round(Math.sqrt(sortedPositions.getFirst().method_10262((class_2382)sourcePos)));
    }

    private static int showLocateResult(class_2168 source, class_2960 location, class_2338 position, class_2338 sourcePosition) {
        int dist = class_3532.method_15375((float)class_3532.method_15355((float)((float)sourcePosition.method_10262((class_2382)position))));
        class_5250 component = class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{position.method_10263(), position.method_10264(), position.method_10260()})).method_27694(style -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/tp @s " + position.method_10263() + " " + position.method_10264() + " " + position.method_10260())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.coordinates.tooltip"))));
        source.method_9226(() -> LocateFeature.lambda$showLocateResult$7(location, (class_2561)component, dist), false);
        return dist;
    }

    private static /* synthetic */ class_2561 lambda$showLocateResult$7(class_2960 location, class_2561 component, int dist) {
        return TextUtil.translatable("worldgendevtools.locatefeature.command.success.nearby", location.toString(), component, dist);
    }
}

