/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.theoneprobe.ForgeEventHandlers;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.providers.BlockProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.EntityProbeInfoEntityProvider;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketGetEntityInfo;
import mcjty.theoneprobe.network.PacketGetInfo;
import mcjty.theoneprobe.network.PacketOpenGui;
import mcjty.theoneprobe.network.PacketReturnEntityInfo;
import mcjty.theoneprobe.network.PacketReturnInfo;
import mcjty.theoneprobe.rendering.ClientSetup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="theoneprobe")
public class TheOneProbe {
    public static final String MODID = "theoneprobe";
    public static final Logger logger = LogManager.getLogger();
    public static TheOneProbeImp theOneProbeImp = new TheOneProbeImp();
    public static boolean baubles = false;
    public static boolean tesla = false;
    public static boolean redstoneflux = false;
    public static final ResourceLocation HASPROBE = ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"hasprobe");
    public static final TagKey<Item> HASPROBE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)HASPROBE);
    private static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"theoneprobe");
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> MATERIAL_DIAMOND_HELMET = ARMOR_MATERIALS.register("diamond_helmet_probe", () -> new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, 3, ArmorItem.Type.CHESTPLATE, 8, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 3, ArmorItem.Type.BODY, 11), 10, SoundEvents.ARMOR_EQUIP_DIAMOND, () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND)}), Collections.emptyList(), 2.0f, 0.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> MATERIAL_IRON_HELMET = ARMOR_MATERIALS.register("iron_helmet_probe", () -> new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, 2, ArmorItem.Type.CHESTPLATE, 6, ArmorItem.Type.LEGGINGS, 5, ArmorItem.Type.BOOTS, 2, ArmorItem.Type.BODY, 5), 10, SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.IRON_INGOT)}), Collections.emptyList(), 0.0f, 0.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> MATERIAL_GOLD_HELMET = ARMOR_MATERIALS.register("gold_helmet_probe", () -> new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, 1, ArmorItem.Type.CHESTPLATE, 5, ArmorItem.Type.LEGGINGS, 3, ArmorItem.Type.BOOTS, 1, ArmorItem.Type.BODY, 7), 10, SoundEvents.ARMOR_EQUIP_GOLD, () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLD_INGOT)}), Collections.emptyList(), 0.0f, 0.0f));
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"theoneprobe");
    public static final Supplier<AttachmentType<Boolean>> ATTACHMENT_TYPE_PLAYER_GOT_NOTE = ATTACHMENT_TYPES.register("playergotnote", () -> AttachmentType.builder(() -> false).serialize((Codec)Codec.BOOL).copyOnDeath().build());
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"theoneprobe");
    public static final Supplier<CreativeModeTab> TAB_PROBE = TABS.register("probe", () -> CreativeModeTab.builder().title((Component)Component.literal((String)"The One Probe")).icon(() -> new ItemStack((ItemLike)ModItems.PROBE)).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).displayItems((featureFlags, output) -> {
        if (ModItems.CREATIVE_PROBE != null) {
            output.accept((ItemLike)ModItems.CREATIVE_PROBE);
        }
        if (ModItems.PROBE != null) {
            output.accept((ItemLike)ModItems.PROBE);
        }
        if (ModItems.DIAMOND_HELMET_PROBE != null) {
            output.accept((ItemLike)ModItems.DIAMOND_HELMET_PROBE);
        }
        if (ModItems.GOLD_HELMET_PROBE != null) {
            output.accept((ItemLike)ModItems.GOLD_HELMET_PROBE);
        }
        if (ModItems.IRON_HELMET_PROBE != null) {
            output.accept((ItemLike)ModItems.IRON_HELMET_PROBE);
        }
        if (ModItems.PROBE_GOGGLES != null) {
            output.accept((ItemLike)ModItems.PROBE_GOGGLES);
        }
        if (ModItems.PROBE_NOTE != null) {
            output.accept((ItemLike)ModItems.PROBE_NOTE);
        }
    }).build());

    public TheOneProbe(ModContainer container, IEventBus bus, Dist dist) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        bus.addListener(this::onRegisterEvent);
        bus.addListener(this::onRegisterPayloadHandler);
        bus.addListener(this::init);
        bus.addListener(Config::onLoad);
        bus.addListener(Config::onReload);
        bus.addListener(this::processIMC);
        TABS.register(bus);
        ATTACHMENT_TYPES.register(bus);
        ARMOR_MATERIALS.register(bus);
        if (dist.isClient()) {
            bus.addListener(ClientSetup::onClientSetup);
            bus.addListener(ClientSetup::onRegisterKeyMappings);
        }
    }

    private void init(FMLCommonSetupEvent event) {
        tesla = ModList.get().isLoaded("tesla");
        if (tesla) {
            logger.log(Level.INFO, "The One Probe Detected TESLA: enabling support");
        }
        if (redstoneflux = ModList.get().isLoaded("redstoneflux")) {
            logger.log(Level.INFO, "The One Probe Detected RedstoneFlux: enabling support");
        }
        if (baubles = ModList.get().isLoaded("baubles")) {
            if (((Boolean)Config.supportBaubles.get()).booleanValue()) {
                logger.log(Level.INFO, "The One Probe Detected Baubles: enabling support");
            } else {
                logger.log(Level.INFO, "The One Probe Detected Baubles but support disabled in config");
                baubles = false;
            }
        }
        NeoForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        TheOneProbe.registerCapabilities();
        TheOneProbeImp.registerElements();
        theOneProbeImp.registerProvider(new DefaultProbeInfoProvider());
        theOneProbeImp.registerProvider(new DebugProbeInfoProvider());
        theOneProbeImp.registerProvider(new BlockProbeInfoProvider());
        theOneProbeImp.registerEntityProvider(new DefaultProbeInfoEntityProvider());
        theOneProbeImp.registerEntityProvider(new DebugProbeInfoEntityProvider());
        theOneProbeImp.registerEntityProvider(new EntityProbeInfoEntityProvider());
        this.configureProviders();
        this.configureEntityProviders();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getTheOneProbe".equalsIgnoreCase(message.method())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(theOneProbeImp);
            }
        });
    }

    public void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0").optional();
        registrar.playToServer(PacketGetEntityInfo.TYPE, PacketGetEntityInfo.CODEC, PacketGetEntityInfo::handle);
        registrar.playToClient(PacketReturnEntityInfo.TYPE, PacketReturnEntityInfo.CODEC, PacketReturnEntityInfo::handle);
        registrar.playToServer(PacketGetInfo.TYPE, PacketGetInfo.CODEC, PacketGetInfo::handle);
        registrar.playToClient(PacketOpenGui.TYPE, PacketOpenGui.CODEC, PacketOpenGui::handle);
        registrar.playToClient(PacketReturnInfo.TYPE, PacketReturnInfo.CODEC, PacketReturnInfo::handle);
    }

    public void onRegisterEvent(RegisterEvent event) {
        event.register(Registries.ITEM, helper -> {
            ModItems.init();
            helper.register(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"probe"), (Object)ModItems.PROBE);
            helper.register(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"creativeprobe"), (Object)ModItems.CREATIVE_PROBE);
            helper.register(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"probenote"), (Object)ModItems.PROBE_NOTE);
            helper.register(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"diamond_helmet_probe"), (Object)ModItems.DIAMOND_HELMET_PROBE);
            helper.register(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"gold_helmet_probe"), (Object)ModItems.GOLD_HELMET_PROBE);
            helper.register(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"iron_helmet_probe"), (Object)ModItems.IRON_HELMET_PROBE);
        });
    }

    private static void registerCapabilities() {
    }

    private void configureProviders() {
        List<IProbeInfoProvider> providers = theOneProbeImp.getProviders();
        ResourceLocation[] defaultValues = new ResourceLocation[providers.size()];
        int i = 0;
        for (IProbeInfoProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] excludedProviders = new String[]{};
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        theOneProbeImp.configureProviders(defaultValues, excluded);
    }

    private void configureEntityProviders() {
        List<IProbeInfoEntityProvider> providers = theOneProbeImp.getEntityProviders();
        String[] defaultValues = new String[providers.size()];
        int i = 0;
        for (IProbeInfoEntityProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] excludedProviders = new String[]{};
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        theOneProbeImp.configureEntityProviders(defaultValues, excluded);
    }
}

