/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import io.netty.buffer.Unpooled;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> SAFE_ITEMSTACK_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM);

        public ItemStack decode(RegistryFriendlyByteBuf buf) {
            return (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ItemStack stack) {
            if (stack.isEmpty()) {
                buf.writeVarInt(0);
            } else {
                buf.writeVarInt(stack.getCount());
                ITEM_STREAM_CODEC.encode((Object)buf, (Object)stack.getItemHolder());
                RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), buf.registryAccess());
                DataComponentPatch.STREAM_CODEC.encode((Object)buffer, (Object)stack.getComponentsPatch());
                if (buffer.writerIndex() <= (Integer)Config.maxPacketToServer.get()) {
                    DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)stack.getComponentsPatch());
                } else {
                    ItemStack copy = new ItemStack((ItemLike)stack.getItem(), stack.getCount());
                    DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)copy.getComponentsPatch());
                }
            }
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Vec3> VEC3_CODEC = new StreamCodec<FriendlyByteBuf, Vec3>(){

        public Vec3 decode(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            }
            return null;
        }

        public void encode(FriendlyByteBuf buf, Vec3 vec3) {
            if (vec3 == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeDouble(vec3.x);
                buf.writeDouble(vec3.y);
                buf.writeDouble(vec3.z);
            }
        }
    };

    public static <B extends FriendlyByteBuf, V extends Enum<V>> StreamCodec<B, V> enumCodecNullable(final Class<V> enumClass) {
        return new StreamCodec<B, V>(){

            public V decode(B buf) {
                int idx = buf.readVarInt();
                if (idx == -1) {
                    return null;
                }
                return ((Enum[])enumClass.getEnumConstants())[idx];
            }

            public void encode(B buf, V value) {
                if (value == null) {
                    buf.writeVarInt(-1);
                } else {
                    buf.writeVarInt(((Enum)value).ordinal());
                }
            }
        };
    }

    public static String getModName(EntityType<?> entry) {
        ResourceLocation registryName = BuiltInRegistries.ENTITY_TYPE.getKey(entry);
        String modId = registryName == null ? "minecraft" : registryName.getNamespace();
        return ModList.get().getModContainerById(modId).map(mod -> mod.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    public static String getModName(Block entry) {
        ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)entry);
        String modId = registryName == null ? "minecraft" : registryName.getNamespace();
        return ModList.get().getModContainerById(modId).map(mod -> mod.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    public static boolean show(ProbeMode mode, IProbeConfig.ConfigMode cfg) {
        return cfg == IProbeConfig.ConfigMode.NORMAL || cfg == IProbeConfig.ConfigMode.EXTENDED && mode == ProbeMode.EXTENDED;
    }
}

