/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.api;

import java.util.Collection;
import java.util.List;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITextStyle;
import mcjty.theoneprobe.api.TankReference;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public interface IProbeInfo {
    public static final String STARTLOC = "{*";
    public static final String ENDLOC = "*}";

    public ILayoutStyle defaultLayoutStyle();

    public IProgressStyle defaultProgressStyle();

    public ITextStyle defaultTextStyle();

    public IItemStyle defaultItemStyle();

    public IEntityStyle defaultEntityStyle();

    public IIconStyle defaultIconStyle();

    public IProbeInfo icon(ResourceLocation var1, int var2, int var3, int var4, int var5, IIconStyle var6);

    public IProbeInfo icon(ResourceLocation var1, int var2, int var3, int var4, int var5);

    public IProbeInfo fluid(FluidStack var1, IIconStyle var2);

    public IProbeInfo entity(String var1, IEntityStyle var2);

    public IProbeInfo entity(String var1);

    public IProbeInfo entity(Entity var1, IEntityStyle var2);

    public IProbeInfo entity(Entity var1);

    public IProbeInfo text(Component var1);

    public IProbeInfo text(Component var1, ITextStyle var2);

    public IProbeInfo mcText(Component var1);

    public IProbeInfo mcText(Component var1, ITextStyle var2);

    default public IProbeInfo text(CompoundText text) {
        return this.text(text.get());
    }

    default public IProbeInfo text(CompoundText text, ITextStyle style) {
        return this.text(text.get(), style);
    }

    default public IProbeInfo text(String text) {
        return this.mcText((Component)Component.translatable((String)text));
    }

    default public IProbeInfo text(String text, Object ... args) {
        return this.mcText((Component)Component.translatable((String)text, (Object[])args));
    }

    default public IProbeInfo text(String text, ITextStyle style) {
        return this.mcText((Component)Component.translatable((String)text), style);
    }

    default public IProbeInfo text(String text, ITextStyle style, Object ... args) {
        return this.mcText((Component)Component.translatable((String)text, (Object[])args), style);
    }

    public IProbeInfo item(ItemStack var1, IItemStyle var2);

    public IProbeInfo item(ItemStack var1);

    public IProbeInfo itemLabel(ItemStack var1, ITextStyle var2);

    public IProbeInfo itemLabel(ItemStack var1);

    public IProbeInfo progress(int var1, int var2, IProgressStyle var3);

    public IProbeInfo progress(int var1, int var2);

    public IProbeInfo progress(long var1, long var3, IProgressStyle var5);

    public IProbeInfo progress(long var1, long var3);

    default public IProbeInfo tankSimple(int capacity, FluidStack fluid) {
        return this.tank(TankReference.createSimple(capacity, fluid));
    }

    default public IProbeInfo tank(IFluidTank tank) {
        return this.tank(TankReference.createTank(tank));
    }

    default public IProbeInfo tankHandler(IFluidHandler handler) {
        return this.tank(TankReference.createHandler(handler));
    }

    public IProbeInfo tank(TankReference var1);

    default public IProbeInfo tankSimple(int capacity, FluidStack fluid, IProgressStyle style) {
        return this.tank(TankReference.createSimple(capacity, fluid), style);
    }

    default public IProbeInfo tank(IFluidTank tank, IProgressStyle style) {
        return this.tank(TankReference.createTank(tank), style);
    }

    default public IProbeInfo tankHandler(IFluidHandler handler, IProgressStyle style) {
        return this.tank(TankReference.createHandler(handler), style);
    }

    public IProbeInfo tank(TankReference var1, IProgressStyle var2);

    public IProbeInfo padding(int var1, int var2);

    public IProbeInfo horizontal(ILayoutStyle var1);

    public IProbeInfo horizontal();

    public IProbeInfo vertical(ILayoutStyle var1);

    public IProbeInfo vertical();

    public IProbeInfo element(IElement var1);

    default public IProbeInfo elements(IElement ... elements) {
        for (IElement element : elements) {
            this.element(element);
        }
        return this;
    }

    default public IProbeInfo elements(Collection<IElement> elements) {
        for (IElement element : elements) {
            this.element(element);
        }
        return this;
    }

    public List<IElement> getElements();
}

