/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.api;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public final class TankReference {
    private final int capacity;
    private final int stored;
    private final FluidStack[] fluids;

    public TankReference(int capacity, int stored, FluidStack ... fluids) {
        this.capacity = capacity;
        this.stored = stored;
        this.fluids = fluids;
    }

    public TankReference(RegistryFriendlyByteBuf buffer) {
        this.capacity = buffer.readInt();
        this.stored = buffer.readInt();
        this.fluids = new FluidStack[buffer.readInt()];
        for (int i = 0; i < this.fluids.length; ++i) {
            this.fluids[i] = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getStored() {
        return this.stored;
    }

    public FluidStack[] getFluids() {
        return this.fluids;
    }

    public static TankReference createSimple(int capacity, FluidStack fluid) {
        return new TankReference(capacity, fluid.getAmount(), fluid);
    }

    public static TankReference createTank(IFluidTank tank) {
        return new TankReference(tank.getCapacity(), tank.getFluidAmount(), tank.getFluid());
    }

    public static TankReference createHandler(IFluidHandler handler) {
        int capacity = 0;
        int stored = 0;
        FluidStack[] fluids = new FluidStack[handler.getTanks()];
        for (int i = 0; i < fluids.length; ++i) {
            FluidStack fluid;
            capacity += handler.getTankCapacity(i);
            fluids[i] = fluid = handler.getFluidInTank(i);
            stored += fluid.getAmount();
        }
        return new TankReference(capacity, stored, fluids);
    }

    public static TankReference[] createSplitHandler(IFluidHandler handler) {
        TankReference[] references = new TankReference[handler.getTanks()];
        for (int i = 0; i < references.length; ++i) {
            FluidStack fluid = handler.getFluidInTank(i);
            references[i] = new TankReference(handler.getTankCapacity(i), fluid.getAmount(), fluid);
        }
        return references;
    }

    public void toBytes(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.capacity);
        buffer.writeInt(this.stored);
        buffer.writeInt(this.fluids.length);
        for (FluidStack fluid : this.fluids) {
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)fluid);
        }
    }
}

