/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.TankReference;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class ElementProgressRender {
    private static final ResourceLocation HEARTH_FULL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/hud/heart/full.png");
    private static final ResourceLocation HEARTH_HALF = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/hud/heart/half.png");
    private static final ResourceLocation ARMOR_FULL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/hud/armor_full.png");
    private static final ResourceLocation ARMOR_HALF = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/hud/armor_half.png");

    public static void render(IProgressStyle style, long current, long max, GuiGraphics graphics, int x, int y, int w, int h) {
        if (style.isLifeBar()) {
            ElementProgressRender.renderLifeBar(current, graphics, x, y, w, h);
        } else if (style.isArmorBar()) {
            ElementProgressRender.renderArmorBar(current, graphics, x, y, w, h);
        } else {
            RenderHelper.drawThickBeveledBox(graphics, x, y, x + w, y + h, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
            if (current > 0L && max > 0L) {
                int dx = (int)Math.min(current * (long)(w - 2) / max, (long)(w - 2));
                if (style.getFilledColor() == style.getAlternatefilledColor()) {
                    if (dx > 0) {
                        RenderHelper.drawThickBeveledBox(graphics, x + 1, y + 1, x + dx + 1, y + h - 1, 1, style.getFilledColor(), style.getFilledColor(), style.getFilledColor());
                    }
                } else {
                    for (int xx = x + 1; xx < x + dx + 1; ++xx) {
                        int color = (xx & 1) == 0 ? style.getFilledColor() : style.getAlternatefilledColor();
                        RenderHelper.drawVerticalLine(graphics, xx, y + 1, y + h - 1, color);
                    }
                }
            }
        }
        ElementProgressRender.renderText(graphics, x, y, w, current, style);
    }

    private static void renderText(GuiGraphics graphics, int x, int y, int w, long current, IProgressStyle style) {
        if (style.isShowText()) {
            Minecraft mc = Minecraft.getInstance();
            Font render = mc.font;
            MutableComponent s = style.getPrefixComp().copy().append(ElementProgress.format(current, style.getNumberFormat(), style.getSuffixComp()));
            int textWidth = render.width(s.getVisualOrderText());
            switch (style.getAlignment()) {
                case ALIGN_BOTTOMRIGHT: {
                    RenderHelper.renderText(mc, graphics, x + w - 3 - textWidth, y + 2, (Component)s);
                    break;
                }
                case ALIGN_CENTER: {
                    RenderHelper.renderText(mc, graphics, x + w / 2 - textWidth / 2, y + 2, (Component)s);
                    break;
                }
                case ALIGN_TOPLEFT: {
                    RenderHelper.renderText(mc, graphics, x + 3, y + 2, (Component)s);
                }
            }
        }
    }

    private static void renderLifeBar(long current, GuiGraphics graphics, int x, int y, int w, int h) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = graphics.pose();
        Matrix4f matrix = matrixStack.last().pose();
        if (current * 4L >= (long)w) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEARTH_FULL);
            RenderHelper.drawTexturedModalRect(matrix, x, y, 0, 0, 9, 9, 9, 9);
            RenderHelper.renderText(Minecraft.getInstance(), graphics, x + 12, y, String.valueOf(ChatFormatting.WHITE) + String.valueOf(current / 2L));
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEARTH_FULL);
            int i = 0;
            while ((long)i < current / 2L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 0, 0, 9, 9, 9, 9);
                x += 8;
                ++i;
            }
            if (current % 2L != 0L) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEARTH_HALF);
                RenderHelper.drawTexturedModalRect(matrix, x, y, 0, 0, 9, 9, 9, 9);
            }
        }
    }

    private static void renderArmorBar(long current, GuiGraphics graphics, int x, int y, int w, int h) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = graphics.pose();
        Matrix4f matrix = matrixStack.last().pose();
        if (current * 4L >= (long)w) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARMOR_FULL);
            RenderHelper.drawTexturedModalRect(matrix, x, y, 0, 0, 9, 9, 9, 9);
            RenderHelper.renderText(Minecraft.getInstance(), graphics, x + 12, y, String.valueOf(ChatFormatting.WHITE) + String.valueOf(current / 2L));
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARMOR_FULL);
            int i = 0;
            while ((long)i < current / 2L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 0, 0, 9, 9, 9, 9);
                x += 8;
                ++i;
            }
            if (current % 2L != 0L) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARMOR_HALF);
                RenderHelper.drawTexturedModalRect(matrix, x, y, 0, 0, 9, 9, 9, 9);
            }
        }
    }

    public static void renderTank(GuiGraphics graphics, int x, int y, int width, int height, IProgressStyle style, TankReference tank) {
        RenderHelper.drawThickBeveledBox(graphics, x, y, x + width, y + height, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
        if (tank.getStored() <= 0) {
            if (style.isShowText()) {
                ElementProgressRender.renderText(graphics, x, y, width, 0L, style);
            }
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        Function map = mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        width -= 2;
        FluidStack[] fluids = tank.getFluids();
        int start = 1;
        int tanks = fluids.length;
        int max = tank.getCapacity();
        PoseStack matrixStack = graphics.pose();
        Matrix4f matrix = matrixStack.last().pose();
        for (FluidStack stack : fluids) {
            ResourceLocation stillTexture;
            TextureAtlasSprite liquidIcon;
            int lvl = (int)(stack == null ? 0.0 : (double)stack.getAmount() / (double)max * (double)width);
            if (lvl <= 0 || Objects.equals(liquidIcon = (TextureAtlasSprite)map.apply(stillTexture = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getStillTexture(stack)), map.apply(MissingTextureAtlasSprite.getLocation()))) continue;
            int color = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor(stack);
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
            while (lvl > 0) {
                int maxX = Math.min(16, lvl);
                lvl -= maxX;
                RenderHelper.drawTexturedModalRect(matrix, x + start, y + 1, liquidIcon, maxX, height - 2);
                start += maxX;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (style.isShowText()) {
            ElementProgressRender.renderText(graphics, x, y, width + 2, tank.getStored(), style);
        }
    }
}

