/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import java.util.EnumSet;
import java.util.Objects;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class ElementTextRender {
    public static void render(Component text, GuiGraphics graphics, int x, int y, boolean legacy) {
        if (legacy) {
            ElementTextRender.render(text, graphics, x, y);
        } else {
            RenderHelper.renderText(Minecraft.getInstance(), graphics, x, y, text);
        }
    }

    public static void render(Component text, GuiGraphics graphics, int x, int y) {
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x, y, ElementTextRender.stylifyString(text));
    }

    private static String stylifyString(Component text) {
        return ElementTextRender.stylifyString(text.getString());
    }

    private static String stylifyString(String text) {
        int end;
        int start;
        while (((String)text).contains("{*") && ((String)text).contains("*}") && (start = ((String)text).indexOf("{*")) < (end = ((String)text).indexOf("*}"))) {
            String left = ((String)text).substring(0, start);
            String middle = ((String)text).substring(start + 2, end);
            middle = I18n.get((String)middle, (Object[])new Object[0]).trim();
            String right = ((String)text).substring(end + 2);
            text = left + middle + right;
        }
        if (((String)text).contains("{=")) {
            String replacement;
            EnumSet<TextStyleClass> stylesNeedingContext = EnumSet.noneOf(TextStyleClass.class);
            TextStyleClass context = null;
            for (TextStyleClass styleClass : Config.textStyleClasses.keySet()) {
                if (!((String)text).contains(styleClass.toString())) continue;
                replacement = Config.getTextStyle(styleClass);
                if ("context".equals(replacement)) {
                    stylesNeedingContext.add(styleClass);
                    continue;
                }
                if (context == null) {
                    context = styleClass;
                    text = StringUtils.replace((String)text, (String)styleClass.toString(), (String)replacement);
                    continue;
                }
                text = StringUtils.replace((String)text, (String)styleClass.toString(), (String)replacement);
            }
            if (context != null) {
                for (TextStyleClass styleClass : stylesNeedingContext) {
                    replacement = Config.getTextStyle(context);
                    text = StringUtils.replace((String)text, (String)styleClass.toString(), (String)replacement);
                }
            }
        }
        return text;
    }

    public static int getLegacyWidth(Component text) {
        return Minecraft.getInstance().font.width(ElementTextRender.stylifyString(text));
    }

    public static int getWidth(Component text) {
        return Minecraft.getInstance().font.width(text.getVisualOrderText());
    }

    public static int getHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9;
    }
}

