/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementIconRender;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class ElementFluid
implements IElement {
    private final FluidStack fluid;
    private final IIconStyle style;

    public ElementFluid(FluidStack fluid, IIconStyle style) {
        this.fluid = fluid;
        this.style = style;
    }

    public ElementFluid(RegistryFriendlyByteBuf buf) {
        this.fluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buf);
        this.style = new IconStyle().width(buf.readInt()).height(buf.readInt()).textureWidth(buf.readInt()).textureHeight(buf.readInt()).color(buf.readInt());
    }

    public IIconStyle getStyle() {
        return this.style;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        int tintColor = IClientFluidTypeExtensions.of((Fluid)this.fluid.getFluid()).getTintColor(this.fluid);
        ResourceLocation stillTexture = IClientFluidTypeExtensions.of((Fluid)this.fluid.getFluid()).getStillTexture();
        Color color = new Color(tintColor);
        ElementIconRender.render(stillTexture, graphics.pose(), x, y, 16, 16, -1, -1, this.style.getTextureWidth(), this.style.getTextureHeight(), color.getRGB());
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        FluidStack.STREAM_CODEC.encode((Object)buf, (Object)this.fluid);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeInt(this.style.getTextureWidth());
        buf.writeInt(this.style.getTextureHeight());
        buf.writeInt(this.style.getColor());
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_FLUID;
    }
}

