/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementPaddingRender;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ElementPadding
implements IElement {
    private final int width;
    private final int height;
    private int color = -1;

    public ElementPadding(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ElementPadding(FriendlyByteBuf buf) {
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.color = buf.readInt();
    }

    public ElementPadding setDebugColor(Color color) {
        this.color = color.getRGB();
        return this;
    }

    public ElementPadding setDebugColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public void render(GuiGraphics stack, int x, int y) {
        if (this.color != -1) {
            ElementPaddingRender.renderPadding(stack, x, y, this.getWidth(), this.getHeight(), this.color);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.width).writeInt(this.height).writeInt(this.color);
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_PADDING;
    }
}

