/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.TankReference;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;

public class ElementTank
implements IElement {
    private final TankReference tank;
    private final IProgressStyle style;

    public ElementTank(TankReference tank) {
        this(tank, new ProgressStyle());
    }

    public ElementTank(TankReference tank, IProgressStyle style) {
        this.tank = tank;
        this.style = style;
    }

    public ElementTank(RegistryFriendlyByteBuf buffer) {
        this.tank = new TankReference(buffer);
        this.style = new ProgressStyle().width(buffer.readInt()).height(buffer.readInt()).prefix((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer)).suffix((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer)).borderColor(buffer.readInt()).filledColor(buffer.readInt()).alternateFilledColor(buffer.readInt()).backgroundColor(buffer.readInt()).showText(buffer.readBoolean()).numberFormat(NumberFormat.values()[buffer.readByte()]).lifeBar(buffer.readBoolean()).armorBar(buffer.readBoolean()).alignment((ElementAlignment)buffer.readEnum(ElementAlignment.class));
    }

    public IProgressStyle getStyle() {
        return this.style;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        ElementProgressRender.renderTank(graphics, x, y, this.getWidth(), this.getHeight(), this.style, this.tank);
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        this.tank.toBytes(buf);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.style.getPrefixComp());
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.style.getSuffixComp());
        buf.writeInt(this.style.getBorderColor());
        buf.writeInt(this.style.getFilledColor());
        buf.writeInt(this.style.getAlternatefilledColor());
        buf.writeInt(this.style.getBackgroundColor());
        buf.writeBoolean(this.style.isShowText());
        buf.writeByte(this.style.getNumberFormat().ordinal());
        buf.writeBoolean(this.style.isLifeBar());
        buf.writeBoolean(this.style.isArmorBar());
        buf.writeEnum((Enum)this.style.getAlignment());
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_TANK;
    }
}

