/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ITextStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.apiimpl.styles.TextStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;

public class ElementText
implements IElement {
    private final Component text;
    private final ITextStyle style;
    private boolean legacy = false;

    public ElementText(String text) {
        this((Component)Component.translatable((String)text), (ITextStyle)new TextStyle());
    }

    public ElementText(String text, ITextStyle style) {
        this((Component)Component.translatable((String)text), style);
    }

    public ElementText(Component text) {
        this(text, (ITextStyle)new TextStyle());
    }

    public ElementText(Component text, ITextStyle style) {
        this.text = text;
        this.style = style;
    }

    public ElementText(RegistryFriendlyByteBuf buf) {
        this.text = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        this.style = new TextStyle().alignment((ElementAlignment)buf.readEnum(ElementAlignment.class)).topPadding(buf.readInt()).bottomPadding(buf.readInt()).leftPadding(buf.readInt()).rightPadding(buf.readInt());
        if (buf.readBoolean()) {
            this.style.width(buf.readInt());
        }
        if (buf.readBoolean()) {
            this.style.height(buf.readInt());
        }
        this.legacy = buf.readBoolean();
    }

    public ITextStyle getStyle() {
        return this.style;
    }

    public ElementText setLegacy() {
        this.legacy = true;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        int width = this.getTextWidth();
        switch (this.style.getAlignment()) {
            case ALIGN_BOTTOMRIGHT: {
                ElementTextRender.render(this.text, graphics, x + this.getInternalWidth() - width + this.style.getLeftPadding(), y + this.style.getTopPadding(), this.legacy);
                break;
            }
            case ALIGN_CENTER: {
                ElementTextRender.render(this.text, graphics, x + this.getInternalWidth() / 2 - width / 2 + this.style.getLeftPadding(), y + this.style.getTopPadding(), this.legacy);
                break;
            }
            case ALIGN_TOPLEFT: {
                ElementTextRender.render(this.text, graphics, x + this.style.getLeftPadding(), y + this.style.getTopPadding(), this.legacy);
            }
        }
    }

    protected int getTextWidth() {
        return this.legacy ? ElementTextRender.getLegacyWidth(this.text) : ElementTextRender.getWidth(this.text);
    }

    protected int getInternalWidth() {
        return this.style.getWidth() != null ? this.style.getWidth().intValue() : this.getTextWidth();
    }

    @Override
    public int getWidth() {
        return this.style.getLeftPadding() + (this.style.getWidth() != null ? this.style.getWidth().intValue() : this.getTextWidth()) + this.style.getRightPadding();
    }

    @Override
    public int getHeight() {
        return this.style.getTopPadding() + (this.style.getHeight() != null ? this.style.getHeight() : ElementTextRender.getHeight()) + this.style.getBottomPadding();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buffer) {
        ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.text);
        buffer.writeEnum((Enum)this.style.getAlignment()).writeInt(this.style.getTopPadding()).writeInt(this.style.getBottomPadding()).writeInt(this.style.getLeftPadding()).writeInt(this.style.getRightPadding());
        buffer.writeBoolean(this.style.getWidth() != null);
        if (this.style.getWidth() != null) {
            buffer.writeInt(this.style.getWidth().intValue());
        }
        buffer.writeBoolean(this.style.getHeight() != null);
        if (this.style.getHeight() != null) {
            buffer.writeInt(this.style.getHeight().intValue());
        }
        buffer.writeBoolean(this.legacy);
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_TEXT;
    }
}

