/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ChestInfoTools {
    static void showChestInfo(ProbeMode mode, IProbeInfo probeInfo, Level world, BlockPos pos, IProbeConfig config) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity randomizable = (RandomizableContainerBlockEntity)blockEntity;
            if (randomizable.lootTable != null) {
                if (mode == ProbeMode.DEBUG) {
                    probeInfo.horizontal().text("Loot table: " + randomizable.lootTable.toString());
                } else {
                    probeInfo.horizontal().text(CompoundText.create().style(TextStyleClass.WARNING).text("Loot hasn't resolved yet!"));
                }
                return;
            }
        }
        ArrayList<Object> stacks = null;
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || (Integer)Config.showSmallChestContentsWithoutSneaking.get() <= 0 && Config.getInventoriesToShow().isEmpty())) {
            int slots;
            if (Config.getInventoriesToShow().contains(BuiltInRegistries.BLOCK.getKey((Object)world.getBlockState(pos).getBlock()))) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if ((Integer)Config.showSmallChestContentsWithoutSneaking.get() > 0 && (slots = ChestInfoTools.getChestContents(world, pos, stacks = new ArrayList())) <= (Integer)Config.showSmallChestContentsWithoutSneaking.get()) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !Config.getInventoriesToNotShow().isEmpty() && Config.getInventoriesToNotShow().contains(BuiltInRegistries.BLOCK.getKey((Object)world.getBlockState(pos).getBlock()))) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Tools.show(mode, chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<ItemStack>();
                ChestInfoTools.getChestContents(world, pos, stacks);
            }
            if (!stacks.isEmpty()) {
                boolean showDetailed = Tools.show(mode, config.getShowChestContentsDetailed()) && stacks.size() <= (Integer)Config.showItemDetailThresshold.get();
                ChestInfoTools.showChestContents(probeInfo, world, pos, stacks, showDetailed);
            }
        }
    }

    private static void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, @Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.getItem())) {
            for (ItemStack s : stacks) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack)) continue;
                s.grow(stack.getCount());
                return;
            }
        }
        stacks.add(stack.copy());
        if (foundItems != null) {
            foundItems.add(stack.getItem());
        }
    }

    private static void showChestContents(IProbeInfo probeInfo, Level world, BlockPos pos, List<ItemStack> stacks, boolean detailed) {
        int rows = 0;
        int idx = 0;
        IProbeInfo horizontal = null;
        IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Config.chestContentsBorderColor).spacing(0));
        if (detailed) {
            for (ItemStack stackInSlot : stacks) {
                horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text(CompoundText.create().info(stackInSlot.getDescriptionId()));
            }
        } else {
            for (ItemStack stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal(new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }

    private static int getChestContents(Level world, BlockPos pos, List<ItemStack> stacks) {
        BlockEntity te = world.getBlockEntity(pos);
        HashSet<Item> foundItems = (Boolean)Config.compactEqualStacks.get() != false ? new HashSet<Item>() : null;
        AtomicInteger maxSlots = new AtomicInteger();
        try {
            IItemHandler capability = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
            if (capability != null) {
                maxSlots.set(capability.getSlots());
                for (int i = 0; i < maxSlots.get(); ++i) {
                    ChestInfoTools.addItemStack(stacks, foundItems, capability.getStackInSlot(i));
                }
            } else if (te instanceof Container) {
                Container inventory = (Container)te;
                maxSlots.set(inventory.getContainerSize());
                for (int i = 0; i < maxSlots.get(); ++i) {
                    ChestInfoTools.addItemStack(stacks, foundItems, inventory.getItem(i));
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Getting the contents of a " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)world.getBlockState(pos).getBlock())) + " (" + te.getClass().getName() + ")", e);
        }
        return maxSlots.get();
    }
}

