/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DebugProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    @Override
    public String getID() {
        return "theoneprobe:entity.debug";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, Entity entity, IProbeHitEntityData data) {
        if (mode == ProbeMode.DEBUG && ((Boolean)Config.showDebugInfo.get()).booleanValue()) {
            IProbeInfo vertical = null;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                vertical = probeInfo.vertical(new LayoutStyle().borderColor(-48060).spacing(2));
                int totalArmorValue = mob.getArmorValue();
                int age = mob.getNoActionTime();
                float absorptionAmount = mob.getAbsorptionAmount();
                float aiMoveSpeed = mob.getSpeed();
                int revengeTimer = mob.getLastHurtByMobTimestamp();
                vertical.text(CompoundText.createLabelInfo("Tot armor: ", totalArmorValue)).text(CompoundText.createLabelInfo("Age: ", age)).text(CompoundText.createLabelInfo("Absorption: ", Float.valueOf(absorptionAmount))).text(CompoundText.createLabelInfo("AI Move Speed: ", Float.valueOf(aiMoveSpeed))).text(CompoundText.createLabelInfo("Revenge Timer: ", revengeTimer));
                if (entity instanceof AgeableMob) {
                    AgeableMob ageable = (AgeableMob)entity;
                    vertical.text(CompoundText.createLabelInfo("Growing Age: ", ageable.getAge()));
                }
            }
        }
    }
}

