/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DebugProbeInfoProvider
implements IProbeInfoProvider {
    @Override
    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"debug");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && ((Boolean)Config.showDebugInfo.get()).booleanValue()) {
            BlockPos pos = data.getPos();
            this.showDebugInfo(probeInfo, world, blockState, pos, data.getSideHit());
        }
    }

    private void showDebugInfo(IProbeInfo probeInfo, Level world, BlockState blockState, BlockPos pos, Direction side) {
        Block block = blockState.getBlock();
        String simpleName = block.getClass().getSimpleName();
        IProbeInfo vertical = probeInfo.vertical(new LayoutStyle().borderColor(-48060).spacing(2)).text(CompoundText.createLabelInfo("Reg Name: ", BuiltInRegistries.BLOCK.getKey((Object)block).toString())).text(CompoundText.createLabelInfo("Unlocname: ", block.getDescriptionId())).text(CompoundText.createLabelInfo("Class: ", simpleName)).text(CompoundText.createLabelInfo("Hardness: ", Float.valueOf(blockState.getDestroySpeed((BlockGetter)world, pos)))).text(CompoundText.createLabelInfo("Power W: ", blockState.getSignal((BlockGetter)world, pos, side.getOpposite())).style(TextStyleClass.LABEL).text(", S: ").style(TextStyleClass.INFO).text(String.valueOf(blockState.getDirectSignal((BlockGetter)world, pos, side.getOpposite())))).text(CompoundText.createLabelInfo("Light: ", block.getLightEmission(blockState, (BlockGetter)world, pos)));
        BlockEntity te = world.getBlockEntity(pos);
        if (te != null) {
            vertical.text(CompoundText.createLabelInfo("TE: ", te.getClass().getSimpleName()));
        }
    }
}

