/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.providers.ChestInfoTools;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import mcjty.theoneprobe.compat.TeslaTools;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class DefaultProbeInfoProvider
implements IProbeInfoProvider {
    private static final String[] NOTE_TABLE = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"};

    @Override
    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"default");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        Block block = blockState.getBlock();
        BlockPos pos = data.getPos();
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IBlockDisplayOverride override : TheOneProbe.theOneProbeImp.getBlockOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, blockState, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoProvider.showStandardBlockInfo(config, mode, probeInfo, blockState, block, world, pos, player, data);
        }
        if (Tools.show(mode, config.getShowCropPercentage())) {
            this.showGrowthLevel(probeInfo, blockState);
        }
        boolean showHarvestLevel = Tools.show(mode, config.getShowHarvestLevel());
        boolean showHarvested = Tools.show(mode, config.getShowCanBeHarvested());
        if (showHarvested && showHarvestLevel) {
            HarvestInfoTools.showHarvestInfo(probeInfo, world, pos, block, blockState, player);
        } else if (showHarvestLevel) {
            HarvestInfoTools.showHarvestLevel(probeInfo, blockState);
        } else if (showHarvested) {
            HarvestInfoTools.showCanBeHarvested(probeInfo, world, pos, blockState, player);
        }
        if (Tools.show(mode, config.getShowRedstone())) {
            this.showRedstonePower(probeInfo, world, blockState, data, block, Tools.show(mode, config.getShowLeverSetting()));
        }
        if (Tools.show(mode, config.getShowLeverSetting())) {
            this.showLeverSetting(probeInfo, world, blockState, data, block);
        }
        ChestInfoTools.showChestInfo(mode, probeInfo, world, pos, config);
        if (config.getRFMode() > 0) {
            this.showEnergy(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowTankSetting()) && config.getTankMode() > 0) {
            this.showTankInfo(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowBrewStandSetting())) {
            this.showBrewingStandInfo(probeInfo, world, data, block);
        }
        if (Tools.show(mode, config.getShowMobSpawnerSetting())) {
            this.showMobSpawnerInfo(probeInfo, world, data, block);
        }
        if (Tools.show(mode, config.getShowNoteblockInfo())) {
            this.showNoteblockInfo(probeInfo, world, data, blockState);
        }
        if (Tools.show(mode, config.getShowSkullInfo())) {
            this.showSkullInfo(probeInfo, world, data, blockState);
        }
    }

    private void showBrewingStandInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, Block block) {
        BlockEntity te;
        if (block instanceof BrewingStandBlock && (te = world.getBlockEntity(data.getPos())) instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)te;
            int brewtime = brewingStand.brewTime;
            int fuel = brewingStand.fuel;
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(new ItemStack((ItemLike)Items.BLAZE_POWDER), probeInfo.defaultItemStyle().width(16).height(16)).text(CompoundText.createLabelInfo("Fuel: ", fuel));
            if (brewtime > 0) {
                probeInfo.text(CompoundText.createLabelInfo("Time: ", brewtime + " ticks"));
            }
        }
    }

    private void showNoteblockInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, BlockState blockState) {
        if (blockState.getBlock() instanceof NoteBlock) {
            int note = (Integer)blockState.getValue((Property)NoteBlock.NOTE);
            NoteBlockInstrument instrument = (NoteBlockInstrument)blockState.getValue((Property)NoteBlock.INSTRUMENT);
            if (note < 0) {
                note = 0;
            } else if (note > 24) {
                note = 24;
            }
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(CompoundText.create().style(TextStyleClass.LABEL).text("Note: ").info(instrument.name().toLowerCase() + " " + NOTE_TABLE[note] + " (" + note + ")"));
        }
    }

    private void showSkullInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, BlockState blockState) {
        SkullBlockEntity skullBlockEntity;
        ResolvableProfile profile;
        BlockEntity te;
        if (blockState.getBlock() instanceof SkullBlock && (te = world.getBlockEntity(data.getPos())) instanceof SkullBlockEntity && (profile = (skullBlockEntity = (SkullBlockEntity)te).getOwnerProfile()) != null) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(CompoundText.create().style(TextStyleClass.LABEL).text("Player: ").info(profile.name().orElse("???")));
        }
    }

    private void showMobSpawnerInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, Block block) {
        BlockEntity te;
        if (block instanceof SpawnerBlock && (te = world.getBlockEntity(data.getPos())) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlock = (SpawnerBlockEntity)te;
            BaseSpawner logic = spawnerBlock.getSpawner();
            CompoundTag tag = logic.nextSpawnData.getEntityToSpawn();
            Optional optional = EntityType.by((CompoundTag)tag);
            optional.ifPresent(type -> probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(CompoundText.create().style(TextStyleClass.LABEL).text("Mob: ").info(type.getDescriptionId())));
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, Level world, BlockState blockState, IProbeHitData data, Block block, boolean showLever) {
        if (showLever && block instanceof LeverBlock) {
            return;
        }
        int redstonePower = block instanceof RedStoneWireBlock ? ((Integer)blockState.getValue((Property)RedStoneWireBlock.POWER)).intValue() : world.getSignal(data.getPos(), data.getSideHit().getOpposite());
        if (redstonePower > 0) {
            probeInfo.horizontal().item(new ItemStack((ItemLike)Items.REDSTONE), probeInfo.defaultItemStyle().width(14).height(14)).text(CompoundText.createLabelInfo("Power: ", redstonePower));
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, Level world, BlockState blockState, IProbeHitData data, Block block) {
        if (block instanceof LeverBlock) {
            Boolean powered = (Boolean)blockState.getValue((Property)LeverBlock.POWERED);
            probeInfo.horizontal().item(new ItemStack((ItemLike)Items.REDSTONE), probeInfo.defaultItemStyle().width(14).height(14)).text(CompoundText.createLabelInfo("State: ", powered != false ? "On" : "Off"));
        } else if (block instanceof ComparatorBlock) {
            ComparatorMode mode = (ComparatorMode)blockState.getValue((Property)ComparatorBlock.MODE);
            probeInfo.text(CompoundText.createLabelInfo("Mode: ", mode.getSerializedName()));
        } else if (block instanceof RepeaterBlock) {
            Boolean locked = (Boolean)blockState.getValue((Property)RepeaterBlock.LOCKED);
            Integer delay = (Integer)blockState.getValue((Property)RepeaterBlock.DELAY);
            probeInfo.text(CompoundText.createLabelInfo("Delay: ", delay + " ticks"));
            if (locked.booleanValue()) {
                probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text("Locked"));
            }
        }
    }

    private void showTankInfo(IProbeInfo probeInfo, Level world, BlockPos pos) {
        ProbeConfig config = Config.getDefaultConfig();
        BlockEntity te = world.getBlockEntity(pos);
        IFluidHandler handler = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
        if (handler != null) {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack fluidStack = handler.getFluidInTank(i);
                int maxContents = handler.getTankCapacity(i);
                if (fluidStack.isEmpty()) continue;
                this.addFluidInfo(probeInfo, config, fluidStack, maxContents);
            }
        }
    }

    private void addFluidInfo(IProbeInfo probeInfo, ProbeConfig config, FluidStack fluidStack, int maxContents) {
        int contents = fluidStack.getAmount();
        if (config.getTankMode() == 1) {
            int tintColor = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
            Color color = new Color(tintColor);
            if (Objects.equals(fluidStack.getFluid(), Fluids.LAVA)) {
                color = new Color(255, 139, 27);
            }
            MutableComponent text = Component.literal((String)"");
            text.append(ElementProgress.format(contents, Config.tankFormat.get(), (Component)Component.literal((String)"mB")));
            text.append("/");
            text.append(ElementProgress.format(maxContents, Config.tankFormat.get(), (Component)Component.literal((String)"mB")));
            probeInfo.tankSimple(maxContents, fluidStack, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.NONE).borderlessColor(color, color.darker().darker()).prefix((Component)((MutableComponent)fluidStack.getHoverName()).append(": ")).suffix((Component)text));
        } else {
            if (!fluidStack.isEmpty()) {
                probeInfo.text(CompoundText.create().style(TextStyleClass.NAME).text("Liquid:").info(fluidStack.getFluidType().getDescriptionId(fluidStack)));
            }
            if (config.getTankMode() == 2) {
                probeInfo.progress(contents, maxContents, probeInfo.defaultProgressStyle().suffix("mB").filledColor(Config.tankbarFilledColor).alternateFilledColor(Config.tankbarAlternateFilledColor).borderColor(Config.tankbarBorderColor).numberFormat(Config.tankFormat.get()));
            } else {
                probeInfo.text(CompoundText.create().style(TextStyleClass.PROGRESS).text(ElementProgress.format(contents, Config.tankFormat.get(), (Component)Component.literal((String)"mB"))));
            }
        }
    }

    private void showEnergy(IProbeInfo probeInfo, Level world, BlockPos pos) {
        ProbeConfig config = Config.getDefaultConfig();
        BlockEntity te = world.getBlockEntity(pos);
        if (TheOneProbe.tesla && TeslaTools.isEnergyHandler(te)) {
            long energy = TeslaTools.getEnergy(te);
            long maxEnergy = TeslaTools.getMaxEnergy(te);
            this.addEnergyInfo(probeInfo, config, energy, maxEnergy);
        } else {
            IEnergyStorage handler = (IEnergyStorage)world.getCapability(Capabilities.EnergyStorage.BLOCK, pos, null);
            if (handler != null) {
                this.addEnergyInfo(probeInfo, config, handler.getEnergyStored(), handler.getMaxEnergyStored());
            }
        }
    }

    private void addEnergyInfo(IProbeInfo probeInfo, ProbeConfig config, long energy, long maxEnergy) {
        if (config.getRFMode() == 1) {
            probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("FE").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat.get()));
        } else {
            probeInfo.text(CompoundText.create().style(TextStyleClass.PROGRESS).text("FE: " + String.valueOf(ElementProgress.format(energy, Config.rfFormat.get(), (Component)Component.literal((String)"FE")))));
        }
    }

    private void showGrowthLevel(IProbeInfo probeInfo, BlockState blockState) {
        for (Property property : blockState.getProperties()) {
            if (!"age".equals(property.getName())) continue;
            if (property.getValueClass() == Integer.class) {
                int maxAge;
                Property integerProperty = property;
                int age = (Integer)blockState.getValue(integerProperty);
                if (age == (maxAge = ((Integer)Collections.max(integerProperty.getPossibleValues())).intValue())) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.OK).text("Fully grown"));
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Growth: ").style(TextStyleClass.WARNING).text(age * 100 / maxAge + "%"));
                }
            }
            return;
        }
    }

    public static void showStandardBlockInfo(IProbeConfig config, ProbeMode mode, IProbeInfo probeInfo, BlockState blockState, Block block, Level world, BlockPos pos, Player player, IProbeHitData data) {
        FluidState fluidState;
        Fluid fluid;
        String modName = Tools.getModName(block);
        ItemStack pickBlock = data.getPickBlock();
        if (block instanceof InfestedBlock && mode != ProbeMode.DEBUG && !Tools.show(mode, config.getShowSilverfish())) {
            block = ((InfestedBlock)block).getHostBlock();
            pickBlock = new ItemStack((ItemLike)block, 1);
        }
        if (block instanceof LiquidBlock && !Objects.equals(fluid = (fluidState = blockState.getFluidState()).getType(), Fluids.EMPTY)) {
            IProbeInfo horizontal = probeInfo.horizontal();
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            horizontal.fluid(fluidStack, probeInfo.defaultIconStyle().width(20));
            ItemStack bucketStack = FluidUtil.getFilledBucket((FluidStack)fluidStack);
            FluidUtil.getFluidContained((ItemStack)bucketStack).ifPresent(fc -> {
                if (FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)fc)) {
                    horizontal.item(bucketStack);
                }
            });
            horizontal.vertical().text(CompoundText.create().name(fluidStack.getFluidType().getDescriptionId(fluidStack))).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
            return;
        }
        if (!pickBlock.isEmpty()) {
            if (Tools.show(mode, config.getShowModName())) {
                probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).itemLabel(pickBlock);
            }
        } else if (Tools.show(mode, config.getShowModName())) {
            probeInfo.vertical().text(CompoundText.create().name(block.getDescriptionId())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
        } else {
            probeInfo.vertical().text(CompoundText.create().name(block.getDescriptionId()));
        }
    }
}

