/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.gui.HitBox;
import mcjty.theoneprobe.gui.Preset;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.tuple.Pair;

public class GuiConfig
extends Screen {
    private static final int WIDTH = 230;
    private static final int HEIGHT = 230;
    private int guiLeft;
    private int guiTop;
    private static final ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"textures/gui/config.png");
    private static final ResourceLocation scene = ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"textures/gui/scene.png");
    private static final List<Preset> presets = new ArrayList<Preset>();
    private List<HitBox> hitboxes = Collections.emptyList();

    public GuiConfig() {
        super((Component)Component.literal((String)"TOP Config"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - 230 - 230) / 2;
        this.guiTop = (this.height - 230) / 2;
    }

    protected void renderMenuBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        graphics.blit(background, this.guiLeft + 230, y, 0.0f, 0.0f, 256, 256, 256, 256);
        graphics.blit(scene, this.guiLeft, y, 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderProbe(graphics);
        int x = 230 + this.guiLeft + 10;
        int y = this.guiTop + 10;
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x, y, String.valueOf(ChatFormatting.GOLD) + "Placement:");
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x + 10, y += 12, "Click on corner in screenshot");
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x + 10, y += 10, "to move tooltip there");
        y += 10;
        this.hitboxes = new ArrayList<HitBox>();
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x, y += 20, String.valueOf(ChatFormatting.GOLD) + "Presets:");
        y += 12;
        for (Preset preset : presets) {
            y = this.addPreset(graphics, x, y, preset);
        }
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x, y += 20, String.valueOf(ChatFormatting.GOLD) + "Scale:");
        this.addButton(graphics, x + 10, y += 12, 30, 14, "--", () -> Config.setScale(1.2f));
        this.addButton(graphics, (x += 36) + 10, y, 30, 14, "-", () -> Config.setScale(1.1f));
        this.addButton(graphics, (x += 36) + 10, y, 30, 14, "0", () -> Config.setScale(1.0f));
        this.addButton(graphics, (x += 36) + 10, y, 30, 14, "+", () -> Config.setScale(0.9f));
        this.addButton(graphics, (x += 36) + 10, y, 30, 14, "++", () -> Config.setScale(0.8f));
        x += 36;
        int margin = 90;
        this.hitboxes.add(new HitBox(0, 0, margin, margin, () -> Config.setPos(5, 5, -1, -1)));
        this.hitboxes.add(new HitBox(margin, 0, 230 - margin, margin, () -> Config.setPos(-1, 5, -1, -1)));
        this.hitboxes.add(new HitBox(230 - margin, 0, 230, margin, () -> Config.setPos(-1, 5, 5, -1)));
        this.hitboxes.add(new HitBox(0, margin, margin, 230 - margin, () -> Config.setPos(5, -1, -1, -1)));
        this.hitboxes.add(new HitBox(margin, margin, 230 - margin, 230 - margin, () -> Config.setPos(-1, -1, -1, -1)));
        this.hitboxes.add(new HitBox(230 - margin, margin, 230, 230 - margin, () -> Config.setPos(-1, -1, 5, -1)));
        this.hitboxes.add(new HitBox(0, 230 - margin, margin, 230, () -> Config.setPos(5, -1, -1, 5)));
        this.hitboxes.add(new HitBox(margin, 230 - margin, 230 - margin, 230, () -> Config.setPos(-1, -1, -1, 20)));
        this.hitboxes.add(new HitBox(230 - margin, 230 - margin, 230, 230, () -> Config.setPos(-1, -1, 5, 5)));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean rc = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (rc) {
            return true;
        }
        if (mouseButton == 0) {
            for (HitBox box : this.hitboxes) {
                if (!box.isHit((int)mouseX - this.guiLeft, (int)mouseY - this.guiTop)) continue;
                box.call();
                return true;
            }
        }
        return false;
    }

    private void applyPreset(Preset preset) {
        Config.setBoxStyle(preset.getBoxThickness(), preset.getBoxBorderColor(), preset.getBoxFillColor(), preset.getBoxOffset());
        for (Map.Entry<TextStyleClass, String> entry : Config.defaultTextStyleClasses.entrySet()) {
            Config.setTextStyle(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<TextStyleClass, String> entry : preset.getTextStyleClasses().entrySet()) {
            Config.setTextStyle(entry.getKey(), entry.getValue());
        }
    }

    private int addPreset(GuiGraphics graphics, int x, int y, Preset preset) {
        graphics.fill(x + 10, y - 1, x + 10 + 230 - 50, y + 10, -16777216);
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x + 20, y, preset.getName());
        this.hitboxes.add(new HitBox(x + 10 - this.guiLeft, y - 1 - this.guiTop, x + 10 + 230 - 50 - this.guiLeft, y + 10 - this.guiTop, () -> this.applyPreset(preset)));
        return y += 14;
    }

    private void addButton(GuiGraphics graphics, int x, int y, int width, int height, String text, Runnable runnable) {
        graphics.fill(x, y, x + width - 1, y + height - 1, -16777216);
        RenderHelper.renderText(Minecraft.getInstance(), graphics, x + 3, y + 3, text);
        this.hitboxes.add(new HitBox(x - this.guiLeft, y - this.guiTop, x + width - 1 - this.guiLeft, y + height - 1 - this.guiTop, runnable));
    }

    private void renderProbe(GuiGraphics graphics) {
        Block block = Blocks.OAK_LOG;
        String modName = Tools.getModName(block);
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ItemStack pickBlock = new ItemStack((ItemLike)block);
        probeInfo.horizontal().item(pickBlock).vertical().text(CompoundText.create().name(pickBlock.getDescriptionId())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
        probeInfo.text(CompoundText.createLabelInfo("Fuel: ", "5 volts"));
        probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Error: ").style(TextStyleClass.ERROR).text("Oups!"));
        this.renderElements(probeInfo, Config.getDefaultOverlayStyle(), graphics);
    }

    private void renderElements(ProbeInfo probeInfo, IOverlayStyle style, GuiGraphics graphics) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        float scale = (float)(1.0 / (Double)Config.tooltipScale.get());
        matrixStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.translate(0.0f, 0.0f, 1.0f);
        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            w += (offset + thick + 3) * 2;
            h += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }
        int x = style.getLeftX() != -1 ? style.getLeftX() : (style.getRightX() != -1 ? 230 - w - style.getRightX() : (230 - w) / 2);
        int y = style.getTopY() != -1 ? style.getTopY() : (style.getBottomY() != -1 ? 230 - h - style.getBottomY() : (230 - h) / 2);
        x += this.guiLeft;
        y += this.guiTop;
        double factor = ((Double)Config.tooltipScale.get() - 1.0) * 1.4 + 1.0;
        x = (int)((double)x * factor);
        y = (int)((double)y * factor);
        if (thick > 0) {
            int x2 = x + w - 1;
            int y2 = y + h - 1;
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(graphics, x, y, x2, y2, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(graphics, x + offset, y + offset, x2 - offset, y2 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (!Minecraft.getInstance().isPaused()) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(graphics, x + margin, y + margin);
        matrixStack.popPose();
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new GuiConfig());
    }

    static {
        presets.add(new Preset("Default style", -6710887, 1426089625, 2, 0, new Pair[0]));
        presets.add(new Preset("WAILA style", -12254256, -16777216, 1, 1, new Pair[0]));
        presets.add(new Preset("Full transparent style", 0, 0, 0, 0, new Pair[0]));
        presets.add(new Preset("Black & White style", -1, -16777216, 2, 0, Pair.of((Object)((Object)TextStyleClass.MODNAME), (Object)"white,italic"), Pair.of((Object)((Object)TextStyleClass.NAME), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.INFO), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.INFOIMP), (Object)"white,bold"), Pair.of((Object)((Object)TextStyleClass.WARNING), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.ERROR), (Object)"white,underline"), Pair.of((Object)((Object)TextStyleClass.OBSOLETE), (Object)"white,strikethrough"), Pair.of((Object)((Object)TextStyleClass.LABEL), (Object)"white,underline"), Pair.of((Object)((Object)TextStyleClass.OK), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.PROGRESS), (Object)"white"), Pair.of((Object)((Object)TextStyleClass.HIGHLIGHTED), (Object)"white")));
    }
}

