/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.items;

import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.compat.BaubleTools;
import mcjty.theoneprobe.items.CreativeProbe;
import mcjty.theoneprobe.items.Probe;
import mcjty.theoneprobe.items.ProbeNote;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModItems {
    public static CreativeProbe CREATIVE_PROBE;
    public static Probe PROBE;
    public static Item DIAMOND_HELMET_PROBE;
    public static Item GOLD_HELMET_PROBE;
    public static Item IRON_HELMET_PROBE;
    public static Item PROBE_GOGGLES;
    public static ProbeNote PROBE_NOTE;

    public static void init() {
        PROBE = new Probe();
        CREATIVE_PROBE = new CreativeProbe();
        DIAMOND_HELMET_PROBE = ModItems.makeHelmet(TheOneProbe.MATERIAL_DIAMOND_HELMET);
        GOLD_HELMET_PROBE = ModItems.makeHelmet(TheOneProbe.MATERIAL_GOLD_HELMET);
        IRON_HELMET_PROBE = ModItems.makeHelmet(TheOneProbe.MATERIAL_IRON_HELMET);
        PROBE_NOTE = new ProbeNote();
        if (TheOneProbe.baubles) {
            PROBE_GOGGLES = BaubleTools.initProbeGoggle();
        }
    }

    private static Item makeHelmet(Holder<ArmorMaterial> material) {
        ArmorItem item = new ArmorItem(material, ArmorItem.Type.HELMET, new Item.Properties()){};
        return item;
    }

    public static boolean isProbeInHand(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.getItem() == PROBE || stack.getItem() == CREATIVE_PROBE) {
            return true;
        }
        return stack.is(TheOneProbe.HASPROBE_TAG);
    }

    private static boolean isProbeHelmet(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.is(TheOneProbe.HASPROBE_TAG);
    }

    public static boolean hasAProbeSomewhere(Player player) {
        return ModItems.hasProbeInHand(player, InteractionHand.MAIN_HAND) || ModItems.hasProbeInHand(player, InteractionHand.OFF_HAND) || ModItems.hasProbeInHelmet(player) || ModItems.hasProbeInBauble(player);
    }

    private static boolean hasProbeInHand(Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        return ModItems.isProbeInHand(item);
    }

    private static boolean hasProbeInHelmet(Player player) {
        ItemStack helmet = player.getInventory().getItem(39);
        return ModItems.isProbeHelmet(helmet);
    }

    private static boolean hasProbeInBauble(Player player) {
        if (TheOneProbe.baubles) {
            return BaubleTools.hasProbeGoggle(player);
        }
        return false;
    }
}

