/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class NetworkTools {
    public static ItemStack readItemStack(RegistryFriendlyByteBuf buf) {
        ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        stack.setCount(buf.readInt());
        return stack;
    }

    public static void writeItemStack(RegistryFriendlyByteBuf buf, ItemStack itemStack) {
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)itemStack);
        buf.writeInt(itemStack.getCount());
    }

    public static String readString(FriendlyByteBuf dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst);
    }

    public static void writeString(FriendlyByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes();
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static String readStringUTF8(FriendlyByteBuf dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst, StandardCharsets.UTF_8);
    }

    public static void writeStringUTF8(FriendlyByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static <T extends Enum<T>> void writeEnumCollection(FriendlyByteBuf buf, Collection<T> collection) {
        buf.writeVarInt(collection.size());
        for (Enum type : collection) {
            buf.writeEnum(type);
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(FriendlyByteBuf buf, Collection<T> collection, Class<T> enumClass) {
        collection.clear();
        int size = buf.readVarInt();
        for (int i = 0; i < size; ++i) {
            collection.add(buf.readEnum(enumClass));
        }
    }

    public static void writeFloat(FriendlyByteBuf buf, Float f) {
        if (f != null) {
            buf.writeBoolean(true);
            buf.writeFloat(f.floatValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Float readFloat(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return Float.valueOf(buf.readFloat());
        }
        return null;
    }
}

