/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketReturnEntityInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGetEntityInfo(ResourceKey<Level> dim, UUID uuid, ProbeMode mode, Vec3 hitVec) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"getentityinfo");
    public static final CustomPacketPayload.Type<PacketGetEntityInfo> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketGetEntityInfo> CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), PacketGetEntityInfo::dim, (StreamCodec)UUIDUtil.STREAM_CODEC, PacketGetEntityInfo::uuid, ProbeMode.STREAM_CODEC, PacketGetEntityInfo::mode, Tools.VEC3_CODEC, PacketGetEntityInfo::hitVec, PacketGetEntityInfo::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketGetEntityInfo create(ResourceKey<Level> dim, ProbeMode mode, HitResult mouseOver, Entity entity) {
        return new PacketGetEntityInfo(dim, entity.getUUID(), mode, mouseOver.getLocation());
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ServerLevel world = (ServerLevel)player.level();
            Entity entity = world.getEntity(this.uuid);
            if (entity != null) {
                ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo(player, this.mode, (Level)world, entity, this.hitVec);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)PacketReturnEntityInfo.create(this.uuid, probeInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).exceptionally(e -> {
            ctx.disconnect((Component)Component.translatable((String)"theoneprobe.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    private static ProbeInfo getProbeInfo(Player player, ProbeMode mode, Level world, Entity entity, Vec3 hitVec) {
        if ((Integer)Config.needsProbe.get() == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if ((Integer)Config.needsProbe.get() == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        if (!Config.getEntityBlacklist().isEmpty()) {
            ResourceLocation rl = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            for (Predicate<ResourceLocation> predicate : Config.getEntityBlacklist()) {
                if (!predicate.test(rl)) continue;
                return null;
            }
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(hitVec);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        Config.setRealConfig(probeConfig);
        List<IProbeInfoEntityProvider> entityProviders = TheOneProbe.theOneProbeImp.getEntityProviders();
        for (IProbeInfoEntityProvider provider : entityProviders) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Error: ").style(TextStyleClass.ERROR).text(provider.getID()));
            }
        }
        return probeInfo;
    }
}

