/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketReturnInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGetInfo(ResourceKey<Level> dim, BlockPos pos, ProbeMode mode, Direction sideHit, Vec3 hitVec, @Nonnull ItemStack pickBlock) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"getinfo");
    public static final CustomPacketPayload.Type<PacketGetInfo> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGetInfo> CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), PacketGetInfo::dim, (StreamCodec)BlockPos.STREAM_CODEC, PacketGetInfo::pos, ProbeMode.STREAM_CODEC, PacketGetInfo::mode, Tools.enumCodecNullable(Direction.class), PacketGetInfo::sideHit, Tools.VEC3_CODEC, PacketGetInfo::hitVec, Tools.SAFE_ITEMSTACK_STREAM_CODEC, PacketGetInfo::pickBlock, PacketGetInfo::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketGetInfo create(ResourceKey<Level> dim, BlockPos pos, ProbeMode mode, HitResult mouseOver, @Nonnull ItemStack pickBlock) {
        Direction sideHit = ((BlockHitResult)mouseOver).getDirection();
        return new PacketGetInfo(dim, pos, mode, sideHit, mouseOver.getLocation(), pickBlock);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ServerLevel world = (ServerLevel)player.level();
            ProbeInfo probeInfo = PacketGetInfo.getProbeInfo(player, this.mode, (Level)world, this.pos, this.sideHit, this.hitVec, this.pickBlock);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)PacketReturnInfo.create(this.dim, this.pos, probeInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    private static ProbeInfo getProbeInfo(Player player, ProbeMode mode, Level world, BlockPos blockPos, Direction sideHit, Vec3 hitVec, @Nonnull ItemStack pickBlock) {
        if ((Integer)Config.needsProbe.get() == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if ((Integer)Config.needsProbe.get() == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        if (world.hasChunkAt(blockPos)) {
            BlockState state = world.getBlockState(blockPos);
            ProbeHitData data = new ProbeHitData(blockPos, hitVec, sideHit, pickBlock);
            IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
            List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
            for (IProbeConfigProvider configProvider : configProviders) {
                configProvider.getProbeConfig(probeConfig, player, world, state, data);
            }
            Config.setRealConfig(probeConfig);
            List<IProbeInfoProvider> providers = TheOneProbe.theOneProbeImp.getProviders();
            for (IProbeInfoProvider provider : providers) {
                try {
                    provider.addProbeInfo(mode, probeInfo, player, world, state, data);
                }
                catch (Throwable e) {
                    ThrowableIdentity.registerThrowable(e);
                    probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Error: ").style(TextStyleClass.ERROR).text(provider.getID().toString()));
                }
            }
        } else {
            probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Error: ").style(TextStyleClass.ERROR).text("Chunk not loaded!"));
        }
        return probeInfo;
    }
}

