/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.gui.GuiConfig;
import mcjty.theoneprobe.gui.GuiNote;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.keys.KeyBindings;
import mcjty.theoneprobe.keys.KeyInputHandler;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;

public class ClientSetup {
    public static boolean ignoreNextGuiClose = false;

    public static void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientSetup());
        NeoForge.EVENT_BUS.register((Object)new KeyInputHandler());
    }

    @SubscribeEvent
    public void onGuiOpen(ScreenEvent.Opening event) {
        if (ignoreNextGuiClose) {
            Screen current = Minecraft.getInstance().screen;
            if (event.getScreen() == null && (current instanceof GuiConfig || current instanceof GuiNote)) {
                ignoreNextGuiClose = false;
                event.setCanceled(true);
            }
        }
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        KeyBindings.init();
        event.register(KeyBindings.toggleVisible);
        event.register(KeyBindings.toggleLiquids);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void renderGameOverlayEvent(RenderGuiLayerEvent.Pre event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.TITLE)) {
            return;
        }
        if ((Boolean)Config.holdKeyToMakeVisible.get() != false ? !KeyBindings.toggleVisible.isDown() : (Boolean)Config.isVisible.get() == false) {
            return;
        }
        if (this.hasItemInEitherHand(ModItems.CREATIVE_PROBE)) {
            OverlayRenderer.renderHUD(ProbeMode.DEBUG, event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaPartialTick(true));
        } else {
            switch ((Integer)Config.needsProbe.get()) {
                case 0: 
                case 3: {
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaPartialTick(true));
                    break;
                }
                case 1: 
                case 2: {
                    if (!ModItems.hasAProbeSomewhere((Player)Minecraft.getInstance().player)) break;
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaPartialTick(true));
                }
            }
        }
    }

    private ProbeMode getModeForPlayer() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (((Boolean)Config.extendedInMain.get()).booleanValue() && this.hasItemInMainHand(ModItems.PROBE)) {
            return ProbeMode.EXTENDED;
        }
        return player.isShiftKeyDown() ? ProbeMode.EXTENDED : ProbeMode.NORMAL;
    }

    private boolean hasItemInEitherHand(Item item) {
        ItemStack mainHeldItem = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offHeldItem = Minecraft.getInstance().player.getItemInHand(InteractionHand.OFF_HAND);
        return mainHeldItem.getItem() == item || offHeldItem.getItem() == item;
    }

    private boolean hasItemInMainHand(Item item) {
        ItemStack mainHeldItem = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
        return mainHeldItem.getItem() == item;
    }
}

