/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.network.PacketGetEntityInfo;
import mcjty.theoneprobe.network.PacketGetInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class OverlayRenderer {
    private static Map<Pair<ResourceKey<Level>, BlockPos>, Pair<Long, ProbeInfo>> cachedInfo = new HashMap<Pair<ResourceKey<Level>, BlockPos>, Pair<Long, ProbeInfo>>();
    private static Map<UUID, Pair<Long, ProbeInfo>> cachedEntityInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
    private static long lastCleanupTime = 0L;
    private static Pair<Long, ProbeInfo> lastPair;
    private static long lastPairTime;
    private static long lastRenderedTime;

    public static void registerProbeInfo(ResourceKey<Level> dim, BlockPos pos, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedInfo.put((Pair<ResourceKey<Level>, BlockPos>)Pair.of(dim, (Object)pos), (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void registerProbeInfo(UUID uuid, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void renderHUD(ProbeMode mode, GuiGraphics graphics, float partialTicks) {
        double dist = (Double)Config.probeDistance.get();
        PoseStack matrixStack = graphics.pose();
        HitResult mouseOver = Minecraft.getInstance().hitResult;
        if (mouseOver != null && mouseOver.getType() == HitResult.Type.ENTITY) {
            matrixStack.pushPose();
            float scale = ((Double)Config.tooltipScale.get()).floatValue();
            float sw = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            float sh = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDEntity(graphics, mode, mouseOver, sw * scale, sh * scale);
            OverlayRenderer.setupOverlayRendering(sw, sh);
            matrixStack.popPose();
            OverlayRenderer.checkCleanup();
            return;
        }
        LocalPlayer entity = Minecraft.getInstance().player;
        Vec3 start = entity.getEyePosition(partialTicks);
        Vec3 vec31 = entity.getViewVector(partialTicks);
        Vec3 end = start.add(vec31.x * dist, vec31.y * dist, vec31.z * dist);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, (Boolean)Config.showLiquids.get() != false ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)entity);
        mouseOver = entity.getCommandSenderWorld().clip(context);
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.getType() == HitResult.Type.BLOCK) {
            matrixStack.pushPose();
            float scale = ((Double)Config.tooltipScale.get()).floatValue();
            float sw = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            float sh = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDBlock(graphics, mode, mouseOver, sw * scale, sh * scale);
            OverlayRenderer.setupOverlayRendering(sw, sh);
            matrixStack.popPose();
        }
        OverlayRenderer.checkCleanup();
    }

    private static void setupOverlayRendering(float sw, float sh) {
        RenderSystem.clear((int)256, (boolean)true);
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, sw, sh, 0.0f, 1000.0f, ClientHooks.getGuiFarPlane());
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.identity();
        posestack.translate(0.0f, 0.0f, 1000.0f - ClientHooks.getGuiFarPlane());
        RenderSystem.applyModelViewMatrix();
    }

    private static void checkCleanup() {
        long time = System.currentTimeMillis();
        if (time > lastCleanupTime + 5000L) {
            OverlayRenderer.cleanupCachedBlocks(time);
            OverlayRenderer.cleanupCachedEntities(time);
            lastCleanupTime = time;
        }
    }

    private static void renderHUDEntity(GuiGraphics graphics, ProbeMode mode, HitResult mouseOver, double sw, double sh) {
        String entityString;
        if (!(mouseOver instanceof EntityHitResult)) {
            return;
        }
        Entity entity = ((EntityHitResult)mouseOver).getEntity();
        if (!Config.getEntityBlacklist().isEmpty()) {
            ResourceLocation rl = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            for (Predicate<ResourceLocation> predicate : Config.getEntityBlacklist()) {
                if (!predicate.test(rl)) continue;
                return;
            }
        }
        if ((entityString = entity.getEncodeId()) == null && !(entity instanceof Player)) {
            return;
        }
        UUID uuid = entity.getUUID();
        LocalPlayer player = Minecraft.getInstance().player;
        long time = System.currentTimeMillis();
        Pair<Long, ProbeInfo> cacheEntry = cachedEntityInfo.get(uuid);
        if (cacheEntry == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, (Player)player);
            }
            if (lastPair != null && time < lastPairTime + (long)((Integer)Config.timeout.get()).intValue()) {
                OverlayRenderer.renderElements(graphics, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            } else if ((Integer)Config.waitingForServerTimeout.get() > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)((Integer)Config.waitingForServerTimeout.get()).intValue()) {
                ProbeInfo info = OverlayRenderer.getWaitingEntityInfo(mode, mouseOver, entity, (Player)player);
                OverlayRenderer.registerProbeInfo(uuid, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements(graphics, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)((Integer)Config.timeout.get()).intValue()) {
                cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)((ProbeInfo)cacheEntry.getRight())));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, (Player)player);
            }
            OverlayRenderer.renderElements(graphics, (ProbeInfo)cacheEntry.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static void requestEntityInfo(ProbeMode mode, HitResult mouseOver, Entity entity, Player player) {
        PacketDistributor.sendToServer((CustomPacketPayload)PacketGetEntityInfo.create((ResourceKey<Level>)player.getCommandSenderWorld().dimension(), mode, mouseOver, entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void renderHUDBlock(GuiGraphics graphics, ProbeMode mode, HitResult mouseOver, double sw, double sh) {
        ResourceKey dimension;
        Pair key;
        Pair<Long, ProbeInfo> cacheEntry;
        float damage;
        if (!(mouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockPos blockPos = ((BlockHitResult)mouseOver).getBlockPos();
        if (blockPos == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getCommandSenderWorld().isEmptyBlock(blockPos)) {
            return;
        }
        long time = System.currentTimeMillis();
        IElement damageElement = null;
        if ((Integer)Config.showBreakProgress.get() > 0 && (damage = Minecraft.getInstance().gameMode.destroyProgress) > 0.0f) {
            damageElement = (Integer)Config.showBreakProgress.get() == 2 ? new ElementText((Component)Component.literal((String)("Progress " + (int)(damage * 100.0f) + "%")).withStyle(ChatFormatting.RED)) : new ElementProgress((long)(damage * 100.0f), 100L, new ProgressStyle().prefix("Progress ").suffix("%").width(85).borderColor(0).filledColor(0).filledColor(-6750208).alternateFilledColor(-11206656));
        }
        if ((cacheEntry = cachedInfo.get(key = Pair.of((Object)(dimension = player.getCommandSenderWorld().dimension()), (Object)blockPos))) == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedInfo.put((Pair<ResourceKey<Level>, BlockPos>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, (Player)player);
            }
            if (lastPair != null && time < lastPairTime + (long)((Integer)Config.timeout.get()).intValue()) {
                OverlayRenderer.renderElements(graphics, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            } else if ((Integer)Config.waitingForServerTimeout.get() > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)((Integer)Config.waitingForServerTimeout.get()).intValue()) {
                ProbeInfo info = OverlayRenderer.getWaitingInfo(mode, mouseOver, blockPos, (Player)player);
                OverlayRenderer.registerProbeInfo((ResourceKey<Level>)dimension, blockPos, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements(graphics, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)((Integer)Config.timeout.get()).intValue()) {
                cachedInfo.put((Pair<ResourceKey<Level>, BlockPos>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)((ProbeInfo)cacheEntry.getRight())));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, (Player)player);
            }
            OverlayRenderer.renderElements(graphics, (ProbeInfo)cacheEntry.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static ProbeInfo getWaitingInfo(ProbeMode mode, HitResult mouseOver, BlockPos blockPos, Player player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        Level world = player.getCommandSenderWorld();
        BlockState blockState = world.getBlockState(blockPos);
        Block block = blockState.getBlock();
        ItemStack pickBlock = block.getCloneItemStack(blockState, mouseOver, (LevelReader)world, blockPos, player);
        ProbeHitData data = new ProbeHitData(blockPos, mouseOver.getLocation(), ((BlockHitResult)mouseOver).getDirection(), pickBlock);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoProvider.showStandardBlockInfo(probeConfig, mode, probeInfo, blockState, block, world, blockPos, player, data);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Error (see log for details)!"));
        }
        probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Waiting for server..."));
        return probeInfo;
    }

    private static ProbeInfo getWaitingEntityInfo(ProbeMode mode, HitResult mouseOver, Entity entity, Player player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(mouseOver.getLocation());
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, probeConfig);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Error (see log for details)!"));
        }
        probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Waiting for server..."));
        return probeInfo;
    }

    private static void requestBlockInfo(ProbeMode mode, HitResult mouseOver, BlockPos blockPos, Player player) {
        Level world = player.getCommandSenderWorld();
        BlockState blockState = world.getBlockState(blockPos);
        Block block = blockState.getBlock();
        ItemStack pickBlock = block.getCloneItemStack(blockState, mouseOver, (LevelReader)world, blockPos, player);
        if (pickBlock == null) {
            pickBlock = ItemStack.EMPTY;
        }
        if (!pickBlock.isEmpty() && Config.getDontSendNBTSet().contains(BuiltInRegistries.ITEM.getKey((Object)pickBlock.getItem()))) {
            pickBlock = new ItemStack((ItemLike)pickBlock.getItem(), pickBlock.getCount());
        }
        PacketDistributor.sendToServer((CustomPacketPayload)PacketGetInfo.create((ResourceKey<Level>)world.dimension(), blockPos, mode, mouseOver, pickBlock), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void renderOverlay(IOverlayStyle style, IProbeInfo probeInfo, GuiGraphics graphics) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        float scale = ((Double)Config.tooltipScale.get()).floatValue();
        float sw = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        float sh = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
        OverlayRenderer.renderElements(graphics, (ProbeInfo)probeInfo, style, sw * scale, sh * scale, null);
        OverlayRenderer.setupOverlayRendering(sw, sh);
        matrixStack.popPose();
    }

    private static void cleanupCachedBlocks(long time) {
        HashMap<Pair<ResourceKey<Level>, BlockPos>, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<Pair<ResourceKey<Level>, BlockPos>, Pair<Long, ProbeInfo>>();
        for (Map.Entry<Pair<ResourceKey<Level>, BlockPos>, Pair<Long, ProbeInfo>> entry : cachedInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)((Integer)Config.timeout.get()).intValue() + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedInfo = newCachedInfo;
    }

    private static void cleanupCachedEntities(long time) {
        HashMap<UUID, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
        for (Map.Entry<UUID, Pair<Long, ProbeInfo>> entry : cachedEntityInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)((Integer)Config.timeout.get()).intValue() + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedEntityInfo = newCachedInfo;
    }

    public static void renderElements(GuiGraphics graphics, ProbeInfo probeInfo, IOverlayStyle style, double sw, double sh, @Nullable IElement extra) {
        if (extra != null) {
            probeInfo.element(extra);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scaledWidth = (int)sw;
        int scaledHeight = (int)sh;
        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            w += (offset + thick + 3) * 2;
            h += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }
        int x = style.getLeftX() != -1 ? style.getLeftX() : (style.getRightX() != -1 ? scaledWidth - w - style.getRightX() : (scaledWidth - w) / 2);
        int y = style.getTopY() != -1 ? style.getTopY() : (style.getBottomY() != -1 ? scaledHeight - h - style.getBottomY() : (scaledHeight - h) / 2);
        if (thick > 0) {
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(graphics, x, y, x + w - 1, y + h - 1, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(graphics, x + offset, y + offset, x + w - 1 - offset, y + h - 1 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (!Minecraft.getInstance().isPaused()) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(graphics, x + margin, y + margin);
        if (extra != null) {
            probeInfo.removeElement(extra);
        }
    }

    static {
        lastPairTime = 0L;
        lastRenderedTime = -1L;
    }
}

