/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderHelper {
    public static float rot = 0.0f;

    public static void renderEntity(Entity entity, PoseStack matrixStack, int xPos, int yPos, float scale) {
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.translate((float)(xPos + 8), (float)(yPos + 24), 50.0f);
        matrixStack.scale(-scale, scale, scale);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(135.0f));
        Lighting.setupForEntityInInventory();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-135.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(rot));
        matrixStack.mulPose(Axis.XP.rotationDegrees(0.0f));
        if (!(entity instanceof Player)) {
            entity.setXRot(0.0f);
            entity.xRotO = 0.0f;
            entity.setYRot(0.0f);
            entity.yRotO = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.yBodyRotO = 0.0f;
                livingEntity.yBodyRot = 0.0f;
                livingEntity.yHeadRot = 0.0f;
                livingEntity.yHeadRotO = 0.0f;
            }
        }
        double ridingOffset = entity.getVehicle() == null ? 0.0 : entity.getVehicleAttachmentPoint((Entity)entity.getVehicle()).y;
        matrixStack.translate(0.0, ridingOffset + (double)(entity instanceof HangingEntity ? 0.5f : 0.0f), 0.0);
        RenderSystem.applyModelViewMatrix();
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        try {
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            dispatcher.setRenderShadow(false);
            dispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (MultiBufferSource)buffer, 0xF000F0);
            buffer.endBatch();
        }
        catch (Exception e) {
            TheOneProbe.logger.error("Error rendering entity!", (Throwable)e);
        }
        dispatcher.setRenderShadow(true);
        Lighting.setupFor3DItems();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        Minecraft.getInstance().gameRenderer.lightTexture().turnOffLightLayer();
        matrixStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawHorizontalLine(GuiGraphics graphics, int x1, int y1, int x2, int color) {
        graphics.fill(x1, y1, x2, y1 + 1, color);
    }

    public static void drawVerticalLine(GuiGraphics graphics, int x1, int y1, int y2, int color) {
        graphics.fill(x1, y1, x1 + 1, y2, color);
    }

    public static void drawThickBeveledBox(GuiGraphics graphics, int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            graphics.fill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor);
        }
        graphics.fill(x1, y1, x2 - 1, y1 + thickness, topleftcolor);
        graphics.fill(x1, y1, x1 + thickness, y2 - 1, topleftcolor);
        graphics.fill(x2 - thickness, y1, x2, y2 - 1, botrightcolor);
        graphics.fill(x1, y2 - thickness, x2, y2, botrightcolor);
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height, int twidth, int theight) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        float zLevel = 0.01f;
        float f = 1.0f / (float)twidth;
        float f1 = 1.0f / (float)theight;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)u * f, (float)(v + height) * f1);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * f, (float)(v + height) * f1);
        buffer.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(u + width) * f, (float)v * f1);
        buffer.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)u * f, (float)v * f1);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)u * f, (float)(v + height) * f1);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * f, (float)(v + height) * f1);
        buffer.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(u + width) * f, (float)v * f1);
        buffer.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)u * f, (float)v * f1);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, TextureAtlasSprite sprite, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float u1 = sprite.getU0();
        float v1 = sprite.getV0();
        float u2 = sprite.getU1();
        float v2 = sprite.getV1();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv(u1, v1);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv(u1, v2);
        buffer.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv(u2, v2);
        buffer.addVertex(matrix, (float)x, (float)y, zLevel).setUv(u2, v1);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static boolean renderItemStack(Minecraft mc, ItemRenderer itemRender, ItemStack itm, GuiGraphics graphics, int x, int y, String txt) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = graphics.pose();
        boolean rc = true;
        if (!itm.isEmpty() && itm.getItem() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, 32.0f);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int short1 = 240;
            int short2 = 240;
            Lighting.setupFor3DItems();
            try {
                graphics.renderItem(itm, x, y, x * y * 31);
                RenderHelper.renderItemStackOverlay(graphics, mc.font, itm, x, y, txt, txt.length() - 2);
            }
            catch (Exception e) {
                ThrowableIdentity.registerThrowable(e);
                rc = false;
            }
            matrixStack.popPose();
            RenderSystem.applyModelViewMatrix();
        }
        return rc;
    }

    public static void renderItemStackOverlay(GuiGraphics graphics, Font fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        PoseStack matrixStack = graphics.pose();
        if (!stack.isEmpty()) {
            LocalPlayer playerEntitysp;
            float f;
            if (stack.getCount() != 1 || text != null) {
                Object s;
                Object object = s = text == null ? String.valueOf(stack.getCount()) : text;
                if (text == null && stack.getCount() < 1) {
                    s = String.valueOf(ChatFormatting.RED) + String.valueOf(stack.getCount());
                }
                matrixStack.translate(0.0, 0.0, 200.0);
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                if (scaled >= 2) {
                    matrixStack.pushPose();
                    matrixStack.scale(0.5f, 0.5f, 0.5f);
                    graphics.drawString(fr, (String)s, (xPosition + 19 - 2) * 2 - fr.width((String)s), yPosition * 2 + 24, 0xFFFFFF);
                    matrixStack.popPose();
                } else if (scaled == 1) {
                    matrixStack.pushPose();
                    matrixStack.scale(0.75f, 0.75f, 0.75f);
                    graphics.drawString(fr, (String)s, (int)((float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.width((String)s)), (int)((float)yPosition * 1.34f + 14.0f), 0xFFFFFF);
                    matrixStack.popPose();
                } else {
                    graphics.drawString(fr, (String)s, xPosition + 19 - 2 - fr.width((String)s), yPosition + 6 + 3, 0xFFFFFF);
                }
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
            }
            if (stack.getItem().isBarVisible(stack)) {
                double health = stack.getItem().getBarWidth(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.getItem().getBarColor(stack);
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                Matrix4f matrix = matrixStack.last().pose();
                RenderHelper.draw(matrix, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(matrix, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderHelper.draw(matrix, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f2 = f = (playerEntitysp = Minecraft.getInstance().player) == null ? 0.0f : playerEntitysp.getCooldowns().getCooldownPercent(stack.getItem(), (float)Minecraft.getInstance().getFrameTimeNs());
            if (f > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderHelper.draw(matrixStack.last().pose(), xPosition, yPosition + (int)Math.floor(16.0f * (1.0f - f)), 16, (int)Math.ceil(16.0f * f), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(Matrix4f matrix, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static int renderText(Minecraft mc, GuiGraphics graphics, int x, int y, String txt) {
        PoseStack matrixStack = graphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 32.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.setupFor3DItems();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        int width = mc.font.width(txt);
        graphics.drawString(mc.font, txt, x, y, 0xFFFFFF);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        matrixStack.popPose();
        return width;
    }

    public static int renderText(Minecraft mc, GuiGraphics graphics, int x, int y, Component text) {
        PoseStack stack = graphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.pushPose();
        stack.translate(0.0f, 0.0f, 32.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.setupFor3DItems();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        int width = mc.font.width(text.getVisualOrderText());
        graphics.drawString(mc.font, text, x, y, 0xFFFFFF);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        stack.popPose();
        return width;
    }

    private static Vector cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    private static Vector sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    public record Vector(float x, float y, float z) {
        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

