/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraLogger;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.entity.EntityManager;
import gg.auroramc.aurora.api.expansions.ExpansionManager;
import gg.auroramc.aurora.api.item.ItemManager;
import gg.auroramc.aurora.api.localization.LanguageProvider;
import gg.auroramc.aurora.api.menu.Requirement;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandlerRegistry;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.user.UserManager;
import gg.auroramc.aurora.expansions.economy.AuroraEconomy;
import gg.auroramc.aurora.expansions.economy.EconomyExpansion;
import gg.auroramc.aurora.expansions.entity.EntityExpansion;
import gg.auroramc.aurora.expansions.item.ItemExpansion;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.numberformat.NumberFormatExpansion;
import gg.auroramc.aurora.expansions.region.RegionExpansion;
import java.util.Locale;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.bukkit.entity.Player;

public class AuroraAPI {
    public static ExpansionManager getExpansions() {
        return Aurora.getExpansionManager();
    }

    public static AuroraLogger getLogger() {
        return Aurora.logger();
    }

    public static AuroraLogger createLogger(String plugin, Supplier<Boolean> debugMode) {
        return new AuroraLogger(plugin, debugMode);
    }

    public static UserManager getUserManager() {
        return Aurora.getUserManager();
    }

    public static AuroraEconomy getDefaultEconomy() {
        return Aurora.getExpansionManager().getExpansion(EconomyExpansion.class).getDefaultEconomy();
    }

    public static AuroraEconomy getEconomy(String providerPluginName) {
        return Aurora.getExpansionManager().getExpansion(EconomyExpansion.class).getEconomy(providerPluginName);
    }

    public static LeaderboardExpansion getLeaderboards() {
        return Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class);
    }

    public static AuroraUser getUser(UUID uuid) {
        return Aurora.getUserManager().getUser(uuid);
    }

    public static String formatNumber(long number) {
        return Aurora.getExpansionManager().getExpansion(NumberFormatExpansion.class).formatWholeNumber(number);
    }

    public static String formatNumber(double number) {
        return Aurora.getExpansionManager().getExpansion(NumberFormatExpansion.class).formatDecimalNumber(number);
    }

    public static String formatNumberShort(double number) {
        return Aurora.getExpansionManager().getExpansion(NumberFormatExpansion.class).formatNumberShort(number);
    }

    public static String formatNumber(Player player, long number) {
        Locale locale = Aurora.getLanguageProvider().getPlayerLocale(player);
        return Aurora.getExpansionManager().getExpansion(NumberFormatExpansion.class).formatWholeNumber(locale, number);
    }

    public static String formatNumber(Player player, double number) {
        Locale locale = Aurora.getLanguageProvider().getPlayerLocale(player);
        return Aurora.getExpansionManager().getExpansion(NumberFormatExpansion.class).formatDecimalNumber(locale, number);
    }

    public static String formatNumberShort(Player player, double number) {
        Locale locale = Aurora.getLanguageProvider().getPlayerLocale(player);
        return Aurora.getExpansionManager().getExpansion(NumberFormatExpansion.class).formatNumberShort(locale, number);
    }

    public static void registerPlaceholderHandler(PlaceholderHandler handler) {
        PlaceholderHandlerRegistry.addHandler(handler);
    }

    public static void removePlaceholderHandler(PlaceholderHandler handler) {
        PlaceholderHandlerRegistry.removeHandler(handler);
    }

    public static RegionExpansion getRegionManager() {
        return Aurora.getExpansionManager().getExpansion(RegionExpansion.class);
    }

    public static ItemManager getItemManager() {
        return Aurora.getExpansionManager().getExpansion(ItemExpansion.class).getItemManager();
    }

    public static EntityManager getEntityManager() {
        return Aurora.getExpansionManager().getExpansion(EntityExpansion.class).getEntityManager();
    }

    public static void registerRequirementHandler(String name, BiFunction<Player, String[], Boolean> resolver) {
        Requirement.register(name, resolver);
    }

    public static void registerCommandDispatcherActionHandler(String id, BiConsumer<Player, String> handler) {
        CommandDispatcher.registerActionHandler(id, handler);
    }

    public static void setLanguageProvider(LanguageProvider provider) {
        Aurora.setLanguageProvider(provider);
    }

    public static LanguageProvider getLanguageProvider() {
        return Aurora.getLanguageProvider();
    }
}

