/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.config;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.config.ConfigManager;
import gg.auroramc.aurora.api.config.decorators.IgnoreField;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AuroraConfig {
    @IgnoreField
    private final File file;
    @IgnoreField
    private final YamlConfiguration rawConfiguration;
    private int configVersion = 0;

    public AuroraConfig(File file, Map<String, Object> migrationParams) {
        this.file = file;
        this.rawConfiguration = new YamlConfiguration();
        try {
            this.rawConfiguration.load(file);
            List<Consumer<YamlConfiguration>> migrationSteps = this.getApplicableMigrationSteps(this.rawConfiguration.getInt("config-version", 0), migrationParams);
            for (Consumer<YamlConfiguration> migration : migrationSteps) {
                migration.accept(this.rawConfiguration);
            }
            if (!migrationSteps.isEmpty()) {
                try {
                    this.rawConfiguration.save(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            Aurora.logger().severe("Config file not found: " + file.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            Aurora.logger().severe("Invalid configuration in file: " + file.getName());
            e.printStackTrace();
        }
    }

    public AuroraConfig(File file) {
        this(file, null);
    }

    private List<Consumer<YamlConfiguration>> getApplicableMigrationSteps(int from, Map<String, Object> migrationParams) {
        if (migrationParams == null) {
            if (this.getMigrationSteps().size() < from) {
                return List.of();
            }
            return this.getMigrationSteps().subList(from, this.getMigrationSteps().size());
        }
        if (this.getMigrationSteps(migrationParams).size() < from) {
            return List.of();
        }
        return this.getMigrationSteps(migrationParams).subList(from, this.getMigrationSteps(migrationParams).size());
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of();
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps(Map<String, Object> params) {
        return List.of();
    }

    public void saveChanges() {
        ConfigManager.save(this, this.rawConfiguration, this.file);
    }

    public CompletableFuture<Void> saveChangesAsync() {
        return CompletableFuture.runAsync(() -> ConfigManager.save(this, this.rawConfiguration, this.file));
    }

    public YamlConfiguration getRawConfig() {
        return this.rawConfiguration;
    }

    public void load() {
        ConfigManager.load(this, (ConfigurationSection)this.rawConfiguration);
    }

    public int getConfigVersion() {
        return this.configVersion;
    }
}

