/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.config;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.config.decorators.IgnoreField;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public final class ConfigManager {
    public static <T> T load(T config, ConfigurationSection section) {
        Field[] fields;
        for (Field field : fields = config.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(IgnoreField.class)) continue;
            field.setAccessible(true);
            String key = ConfigManager.serializeKey(field.getName());
            try {
                if (Map.class.isAssignableFrom(field.getType())) {
                    ConfigManager.handleMapLoading(field, config, section.getConfigurationSection(key));
                    continue;
                }
                if (List.class.isAssignableFrom(field.getType())) {
                    ConfigManager.handleListLoading(field, config, section, key);
                    continue;
                }
                if (Set.class.isAssignableFrom(field.getType())) {
                    ConfigManager.handleSetLoading(field, config, section, key);
                    continue;
                }
                if (ConfigManager.isPrimitiveOrWrapper(field.getType())) {
                    Object value = ConfigManager.loadPrimitiveType(config, field, section, key);
                    field.set(config, value);
                    continue;
                }
                if (ConfigurationSection.class.isAssignableFrom(field.getType())) {
                    field.set(config, section.getConfigurationSection(key));
                    continue;
                }
                ConfigurationSection nestedSection = section.getConfigurationSection(key);
                if (nestedSection == null) continue;
                Object nestedObject = field.getType().newInstance();
                ConfigManager.load(nestedObject, nestedSection);
                field.set(config, nestedObject);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    private static void handleMapLoading(Field field, Object config, ConfigurationSection section) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 2) {
            return;
        }
        Class keyType = (Class)typeArguments[0];
        Class valueType = (Class)typeArguments[1];
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (section == null) {
            try {
                field.setAccessible(true);
                if (field.get(config) == null) {
                    field.set(config, map);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return;
        }
        for (String keyString : section.getKeys(false)) {
            Object mapValue;
            Object mapKey = ConfigManager.convertKey(keyType, keyString);
            if (mapKey == null) continue;
            if (ConfigManager.isPrimitiveOrWrapper(valueType)) {
                mapValue = ConfigManager.getPrimitive(valueType, section, keyString);
            } else if (ConfigurationSection.class.isAssignableFrom(valueType)) {
                mapValue = section.getConfigurationSection(keyString);
            } else {
                ConfigurationSection subSection = section.getConfigurationSection(keyString);
                if (subSection == null) continue;
                try {
                    mapValue = valueType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ConfigManager.load(mapValue, subSection);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            map.put(mapKey, mapValue);
        }
        try {
            field.setAccessible(true);
            field.set(config, map);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static ConfigurationSection deepMapToConfigurationSection(Map<?, ?> map) {
        MemoryConfiguration section = new MemoryConfiguration();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                section.set(entry.getKey().toString(), (Object)ConfigManager.deepMapToConfigurationSection((Map)entry.getValue()));
                continue;
            }
            section.set(entry.getKey().toString(), entry.getValue());
        }
        return section;
    }

    private static void handleListLoading(Field field, Object config, ConfigurationSection section, String key) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        List listSection = section.getList(key);
        if (listSection == null) {
            if (field.get(config) == null) {
                field.set(config, new ArrayList());
            }
            return;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type typeArgument = parameterizedType.getActualTypeArguments()[0];
        if (!(typeArgument instanceof Class)) {
            return;
        }
        Class itemType = (Class)typeArgument;
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object elem : listSection) {
            if (elem instanceof Map) {
                Map subSection = (Map)elem;
                Object item = itemType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigurationSection ss = ConfigManager.deepMapToConfigurationSection(subSection);
                ConfigManager.load(item, ss);
                list.add(item);
                continue;
            }
            if (!ConfigManager.isPrimitiveOrWrapper(itemType)) continue;
            list.add(ConfigManager.loadPrimitiveType(itemType, elem));
        }
        field.set(config, list);
    }

    private static void handleSetLoading(Field field, Object config, ConfigurationSection section, String key) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        List listSection = section.getList(key);
        if (listSection == null) {
            if (field.get(config) == null) {
                field.set(config, new HashSet());
            }
            return;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type typeArgument = parameterizedType.getActualTypeArguments()[0];
        if (!(typeArgument instanceof Class)) {
            return;
        }
        Class itemType = (Class)typeArgument;
        HashSet<Object> list = new HashSet<Object>();
        for (Object elem : listSection) {
            if (elem instanceof Map) {
                Map subSection = (Map)elem;
                Object item = itemType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigurationSection ss = ConfigManager.deepMapToConfigurationSection(subSection);
                ConfigManager.load(item, ss);
                list.add(item);
                continue;
            }
            if (!ConfigManager.isPrimitiveOrWrapper(itemType)) continue;
            list.add(ConfigManager.loadPrimitiveType(itemType, elem));
        }
        field.set(config, list);
    }

    public static String serializeKey(String fieldName) {
        return fieldName.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase(Locale.ROOT);
    }

    private static Object loadPrimitiveType(Object config, Field field, ConfigurationSection section, String key) throws IllegalAccessException {
        Class<?> type = field.getType();
        if (!section.contains(key) && field.get(config) != null) {
            if (type == Integer.TYPE || type == Double.TYPE || type == Long.TYPE || type == Float.TYPE) {
                return -1;
            }
            return field.get(config);
        }
        return ConfigManager.getPrimitive(type, section, key);
    }

    @Nullable
    public static Object getPrimitive(Class<?> type, ConfigurationSection section, String key) {
        if (type == Integer.class || type == Integer.TYPE) {
            return section.contains(key) || type == Integer.TYPE ? Integer.valueOf(section.getInt(key, -1)) : null;
        }
        if (type == Double.class || type == Double.TYPE) {
            return section.contains(key) || type == Double.TYPE ? Double.valueOf(section.getDouble(key, -1.0)) : null;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return section.contains(key) || type == Boolean.TYPE ? Boolean.valueOf(section.getBoolean(key)) : null;
        }
        if (type == Long.class || type == Long.TYPE) {
            return section.contains(key) || type == Long.TYPE ? Long.valueOf(section.getLong(key)) : null;
        }
        if (type == Float.class || type == Float.TYPE) {
            return section.contains(key) || type == Float.TYPE ? Float.valueOf((float)section.getDouble(key, -1.0)) : null;
        }
        if (type == String.class) {
            return section.getString(key);
        }
        if (type == Character.class || type == Character.TYPE) {
            String str = section.getString(key);
            return str != null && !str.isEmpty() ? Character.valueOf(str.charAt(0)) : null;
        }
        return null;
    }

    private static Object loadPrimitiveType(Class<?> type, Object value) {
        if (value == null) {
            return null;
        }
        return type.cast(value);
    }

    private static boolean isPrimitiveOrWrapper(Class<?> type) {
        return type.isPrimitive() || type == Double.class || type == Float.class || type == Long.class || type == Integer.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class || type == String.class;
    }

    private static Object convertKey(Class<?> keyType, String key) {
        if (keyType == String.class) {
            return key;
        }
        if (keyType == Integer.class || keyType == Integer.TYPE) {
            return Integer.parseInt(key);
        }
        if (keyType == Long.class || keyType == Long.TYPE) {
            return Long.parseLong(key);
        }
        return null;
    }

    private static Map<String, Object> deepMapObjectToMap(Object object) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String key = ConfigManager.serializeKey(field.getName());
            try {
                ArrayList<Map<String, Object>> complexList;
                Type typeArgument;
                ParameterizedType parameterizedType;
                Collection list;
                if (ConfigManager.isPrimitiveOrWrapper(field.getType())) {
                    map.put(key, field.get(object));
                    continue;
                }
                if (Set.class.isAssignableFrom(field.getType())) {
                    list = (Set)field.get(object);
                    Type type = field.getGenericType();
                    if (!(type instanceof ParameterizedType)) continue;
                    parameterizedType = (ParameterizedType)type;
                    typeArgument = parameterizedType.getActualTypeArguments()[0];
                    if (!(typeArgument instanceof Class)) continue;
                    Class clazz = (Class)typeArgument;
                    if (ConfigManager.isPrimitiveOrWrapper(clazz)) {
                        map.put(key, list);
                        continue;
                    }
                    complexList = new ArrayList<Map<String, Object>>();
                    for (Object elem : list) {
                        if (elem == null) continue;
                        complexList.add(ConfigManager.deepMapObjectToMap(elem));
                    }
                    map.put(key, complexList);
                    continue;
                }
                if (List.class.isAssignableFrom(field.getType())) {
                    list = (List)field.get(object);
                    typeArgument = field.getGenericType();
                    if (!(typeArgument instanceof ParameterizedType)) continue;
                    parameterizedType = (ParameterizedType)typeArgument;
                    typeArgument = parameterizedType.getActualTypeArguments()[0];
                    if (!(typeArgument instanceof Class)) continue;
                    Class clazz = (Class)typeArgument;
                    if (ConfigManager.isPrimitiveOrWrapper(clazz)) {
                        map.put(key, list);
                        continue;
                    }
                    complexList = new ArrayList();
                    for (Object elem : list) {
                        if (elem == null) continue;
                        complexList.add(ConfigManager.deepMapObjectToMap(elem));
                    }
                    map.put(key, complexList);
                    continue;
                }
                if (Map.class.isAssignableFrom(field.getType())) {
                    Map mapObject = (Map)field.get(object);
                    HashMap serializedMap = new HashMap();
                    for (Map.Entry entry : mapObject.entrySet()) {
                        if (ConfigManager.isPrimitiveOrWrapper(entry.getValue().getClass())) {
                            serializedMap.put(entry.getKey().toString(), entry.getValue());
                            continue;
                        }
                        serializedMap.put(entry.getKey().toString(), ConfigManager.deepMapObjectToMap(entry.getValue()));
                    }
                    map.put(key, serializedMap);
                    continue;
                }
                map.put(key, ConfigManager.deepMapObjectToMap(field.get(object)));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static void saveObject(Object config, ConfigurationSection section) {
        Field[] fields;
        for (Field field : fields = config.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(IgnoreField.class)) continue;
            String key = ConfigManager.serializeKey(field.getName());
            try {
                ArrayList<Map<String, Object>> complexList;
                field.setAccessible(true);
                Object fieldValue = field.get(config);
                if (fieldValue == null) continue;
                if (ConfigManager.isPrimitiveOrWrapper(field.getType())) {
                    section.set(key, fieldValue);
                    continue;
                }
                if (List.class.isAssignableFrom(field.getType())) {
                    List list = (List)fieldValue;
                    if (!list.isEmpty() && ConfigManager.isPrimitiveOrWrapper(list.get(0).getClass())) {
                        section.set(key, (Object)list);
                        continue;
                    }
                    complexList = new ArrayList<Map<String, Object>>();
                    for (Object elem : list) {
                        if (elem == null) continue;
                        complexList.add(ConfigManager.deepMapObjectToMap(elem));
                    }
                    section.set(key, complexList);
                    continue;
                }
                if (Set.class.isAssignableFrom(field.getType())) {
                    Set set = (Set)fieldValue;
                    if (!set.isEmpty() && ConfigManager.isPrimitiveOrWrapper(set.stream().findFirst().get().getClass())) {
                        section.set(key, new ArrayList(set));
                        continue;
                    }
                    complexList = new ArrayList();
                    for (Object elem : set) {
                        if (elem == null) continue;
                        complexList.add(ConfigManager.deepMapObjectToMap(elem));
                    }
                    section.set(key, complexList);
                    continue;
                }
                if (Map.class.isAssignableFrom(field.getType())) {
                    Map map = (Map)fieldValue;
                    for (Map.Entry entry : map.entrySet()) {
                        String mapKey = String.valueOf(entry.getKey());
                        Object mapValue = entry.getValue();
                        if (ConfigManager.isPrimitiveOrWrapper(mapValue.getClass())) {
                            section.set(key + "." + mapKey, mapValue);
                            continue;
                        }
                        ConfigurationSection mapSection = section.createSection(key + "." + mapKey);
                        ConfigManager.saveObject(mapValue, mapSection);
                    }
                    continue;
                }
                if (ConfigurationSection.class.isAssignableFrom(field.getType())) {
                    section.set(key, fieldValue);
                    continue;
                }
                ConfigurationSection nestedSection = section.createSection(key);
                ConfigManager.saveObject(fieldValue, nestedSection);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save(Object config, YamlConfiguration yaml, File file) {
        ConfigManager.saveObject(config, (ConfigurationSection)yaml);
        try {
            yaml.save(file);
        }
        catch (IOException e) {
            ((Aurora)Aurora.getPlugin(Aurora.class)).getLogger().warning("Failed to save " + file.getAbsolutePath());
        }
    }

    public static void syncConfigurations(ConfigurationSection oldConfig, ConfigurationSection newConfig) {
        ConfigManager.removeExtraKeys(oldConfig, newConfig);
        ConfigManager.addMissingKeys(oldConfig, newConfig);
    }

    private static void removeExtraKeys(ConfigurationSection oldConfig, ConfigurationSection newConfig) {
        oldConfig.getKeys(true).forEach(key -> {
            if (!newConfig.contains(key)) {
                oldConfig.set(key, null);
            }
        });
    }

    private static void addMissingKeys(ConfigurationSection oldConfig, ConfigurationSection newConfig) {
        for (String key : newConfig.getKeys(false)) {
            if (!oldConfig.contains(key)) {
                oldConfig.set(key, newConfig.get(key));
                continue;
            }
            if (!newConfig.isConfigurationSection(key) || !oldConfig.isConfigurationSection(key)) continue;
            ConfigManager.addMissingKeys(oldConfig.getConfigurationSection(key), newConfig.getConfigurationSection(key));
        }
    }
}

